/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.client.impl;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.client.SystemClient;
import com.geoway.sso.client.client.impl.Client;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysSystemConsult;
import com.geoway.sso.client.rpc.RpcSysTenant;
import com.geoway.sso.client.rpc.RpcSystemInfoDTO;
import com.geoway.sso.client.util.UisUtils;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SystemClientImpl
extends Client
implements SystemClient {
    @Override
    public RpcSystemInfoDTO querySystemInfoByKey(String systemKey) {
        Result<RpcSystemInfoDTO> result = UisUtils.querySystemInfoByKey(this.provider.getRpcClientInfo().getServerUrl(), systemKey, this.getHeader());
        if (result == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public List<RpcSysTenant> queryTenants(String systemId) {
        Result<List<RpcSysTenant>> result;
        if (ObjectUtil.isNotEmpty((Object)this.provider.getRpcClientInfo().getSystemId())) {
            systemId = this.provider.getRpcClientInfo().getSystemId();
        }
        if ((result = UisUtils.querySystemTenants(this.provider.getRpcClientInfo().getServerUrl(), systemId, this.getHeader())) == null) {
            return null;
        }
        if (result.isSuccess()) {
            return result.getData();
        }
        throw new RuntimeException(result.getMessage());
    }

    @Override
    public Result<Void> saveSystemConsult(RpcSysSystemConsult consult) {
        return UisUtils.saveSystemConsult(this.provider.getRpcClientInfo().getServerUrl(), consult, this.getHeader());
    }
}

