package com.geoway.sso.client.filter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.session.SessionAccessToken;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.SessionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author ALMJ
 * @desc res单点登录Filter(用户移动APP 、 前后端分离的应用单点登录拦截)
 */
public class AppLoginFilter extends LoginFilter {

    @Override
    public boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        //处理跨域访问时的预请求
        //参考: https://segmentfault.com/q/1010000012364132
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(HttpServletResponse.SC_OK);
            return true;
        }
        String accessToken = CommonLoginUserUtil.getToken();
        //验证基于cookie的accessToken
        if (StrUtil.isEmpty(accessToken)) {
            markLoginResponse(response, "access_token参数为空!");
            return false;
        }
        SessionAccessToken sessionAccessToken = SessionUtils.getAccessToken(request, accessToken);
        if (sessionAccessToken != null && (!sessionAccessToken.isExpired()
                || refreshToken(sessionAccessToken.getRefreshToken(), request))) {
            return true;
        }
        //本地没找到对应的token则单点查询看看有没有
        Result<RpcAccessToken> queryResult = queryAccessToken(accessToken, request);
        if (ObjectUtil.isNotNull(queryResult) && queryResult.isSuccess()) {
            setAccessTokenInSession(queryResult.getData(), request);
            return true;
        }
        markLoginResponse(response, null);
        return false;
    }

}