package com.geoway.sso.client.filter;

import com.geoway.sso.client.listener.LogoutListener;
import com.geoway.sso.client.session.SessionMappingStorage;

import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author ALMJ
 * @title Filter基类
 * @desc 第三方集成时自己实现这个过滤器接口也可以
 */
public abstract class ClientFilter extends ParamFilter implements Filter {
    private SessionMappingStorage sessionMappingStorage;

    /**
     * 是拦截还是放行
     *
     * @param request
     * @param response
     * @return
     * @throws IOException
     */
    public abstract boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response)
            throws IOException;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException {
    }

    @Override
    public void destroy() {
    }

    protected SessionMappingStorage getSessionMappingStorage() {
        if (sessionMappingStorage == null) {
            sessionMappingStorage = LogoutListener.getSessionMappingStorage();
        }
        return sessionMappingStorage;
    }
}