package com.geoway.sso.client.filter;

import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.session.SessionAccessToken;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.Oauth2Utils;
import com.geoway.sso.client.util.SessionUtils;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLEncoder;

/**
 * @author ALMJ
 * @desc res单点登录Filter(移动用户APP 、 前后端分离的应用单点登录拦截)
 */

public class RestLoginFilter extends LoginFilter {
    @Override
    public boolean isAccessAllowed(HttpServletRequest request, HttpServletResponse response) throws IOException {
        //处理跨域访问时的预请求
        //参考: https://segmentfault.com/q/1010000012364132
        if (request.getMethod().equals("OPTIONS")) {
            response.setStatus(HttpServletResponse.SC_OK);
            return true;
        }
        String accessToken = CommonLoginUserUtil.getToken();
        //验证基于cookie的accessToken
        if (accessToken != null) {
            SessionAccessToken sessionAccessToken = SessionUtils.getAccessToken(request, accessToken);
            if (sessionAccessToken != null && (!sessionAccessToken.isExpired()
                    || refreshToken(sessionAccessToken.getRefreshToken(), request))) {
                return true;
            } else {
                //本地没找到对应的token则单点查询看看有没有
                Result<RpcAccessToken> queryResult = queryAccessToken(accessToken, request);
                if (queryResult == null) {
                    redirectAjaxLogin(request, response, "登录授权失败!");
                } else {
                    if (queryResult.isSuccess()) {
                        setAccessTokenInSession(queryResult.getData(), request);
                        return true;
                    } else {
                        redirectAjaxLogin(request, response, queryResult.getMessage());
                    }
                }
            }
        }
        // 第一次登陆跳转后授权码模式登陆放行
        String code = request.getParameter(Oauth2Constant.AUTH_CODE);
        if (code != null && code.length() > 5) {
            // 获取accessToken
            getAccessToken(code, request);
            // 为去掉URL中授权码参数，再跳转一次当前地址
            redirectLocalRemoveCode(request, response);
        } else {
            redirectAjaxLogin(request, response, "登陆失败！");
        }
        return false;
    }

    /**
     * 跳转至服务端登录
     *
     * @param request
     * @param response
     * @throws IOException
     */
    private void redirectAjaxLogin(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        JSONObject resultObject = new JSONObject();
        String loginUrl = new StringBuilder().append(getServerUrl()).append(SsoConstant.LOGIN_URL).append("?")
                .append(Oauth2Constant.APP_ID).append("=").append(getAppId()).append("&")
                .append(SsoConstant.REDIRECT_URI).append("=").append(request.getRequestURL()).append("&")
                .append(SsoConstant.CLIENT_INDEX_URL).append("=").toString();
        resultObject.put("loginUrl", loginUrl);
        Result<JSONObject> result = Result.createLoginRedirect(resultObject, msg);
        responseJson(response, result);
    }


//    private boolean setAccessTokenInSession(RpcAccessToken rpcAccessToken, HttpServletRequest request) {
//        if (rpcAccessToken == null) {
//            return false;
//        }
//        // 记录accessToken到本地session
//        SessionUtils.setAccessToken(request, rpcAccessToken);
//        // 记录本地session和accessToken映射
//        recordSession(request, rpcAccessToken.getAccessToken(), rpcAccessToken.getUser().getLoginName());
//        return true;
//    }

    private void recordSession(final HttpServletRequest request, String accessToken, String userName) {
        final HttpSession session = request.getSession();
        getSessionMappingStorage().removeBySessionById(session.getId());
        getSessionMappingStorage().addSessionById(accessToken, session);
        getSessionMappingStorage().removeTokenByUserName(userName);
        getSessionMappingStorage().addTokenByUserName(accessToken, userName);
    }

    protected boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }


}