package com.geoway.sso.client.session;

import javax.servlet.http.HttpSession;

/**
 * @author ALMJ
 * @desc 借鉴CAS 存 session
 */
public interface SessionMappingStorage {

    /**
     * 删除sesssion
     *
     * @param accessToken
     * @return
     */
    HttpSession removeSessionByMappingId(String accessToken);

    /**
     * 删除session中的token
     *
     * @param sessionId
     */
    void removeBySessionById(String sessionId);

    /**
     * 将accessToken存到session
     *
     * @param accessToken
     * @param session
     */
    void addSessionById(String accessToken, HttpSession session);


    /**
     * 将access_token以用户名为key存一份
     *
     * @param accessToken
     * @param userName
     */
    void addTokenByUserName(String accessToken, String userName);

    /**
     * 删除按用户名存的token
     *
     * @param userName
     */
    void removeTokenByUserName(String userName);

    /**
     * 获取按用户名存的token
     *
     * @param userName
     * @return
     */
    String getTokenByUserName(String userName);


}
