package com.geoway.sso.client.session.local;


import com.geoway.sso.client.session.SessionMappingStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ALMJ
 * @desc 借鉴CAS
 */
@Component
@ConditionalOnProperty(value = "sso.session.manager", havingValue = "local")
public final class LocalSessionMappingStorage implements SessionMappingStorage {

    private final Map<String, HttpSession> tokenSessionMap = new HashMap<>();
    private final Map<String, String> sessionTokenMap = new HashMap<>();

    @Override
    public synchronized void addSessionById(final String accessToken, final HttpSession session) {
        sessionTokenMap.put(session.getId(), accessToken);
        tokenSessionMap.put(accessToken, session);
    }

    @Override
    public void addTokenByUserName(String accessToken, String userName) {
        sessionTokenMap.put(userName, accessToken);
    }

    @Override
    public void removeTokenByUserName(String userName) {
        sessionTokenMap.remove(userName);
    }

    @Override
    public String getTokenByUserName(String userName) {
        return sessionTokenMap.get(userName);
    }

    @Override
    public synchronized void removeBySessionById(final String sessionId) {
        final String accessToken = sessionTokenMap.get(sessionId);
        tokenSessionMap.remove(accessToken);
        sessionTokenMap.remove(sessionId);
    }

    @Override
    public synchronized HttpSession removeSessionByMappingId(final String accessToken) {
        final HttpSession session = tokenSessionMap.get(accessToken);
        if (session != null) {
            removeBySessionById(session.getId());
        }
        return session;
    }
}
