package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.filter.ParamFilter;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;

/**
 * 获取当前登录用户的相关方法
 *
 * @author ALMJ
 * @date 2022/6/24 11:47
 */
@Component
public class CommonLoginUserUtil extends ParamFilter {

    private static String serverUrl;

    @Value("${sso.server.url:null}")
    public void setAddress(String url) {
        this.serverUrl = url;
    }

    /**
     * 获取当前登录用户Token
     *
     * @return
     */

    public static String getToken() {
        // 获取当前http请求
        HttpServletRequest request = HttpServletUtil.getRequest();
        // 1. 优先从param参数中获取token
        String parameterToken = request.getParameter(SsoConstant.PARAM_TOKEN);
        // 不为空则直接返回param的token
        if (StrUtil.isNotBlank(parameterToken)) {
            return parameterToken;
        }

        // 2. 从header中获取token
        String authToken = request.getHeader(SsoConstant.HEADER_ACCESS_TOKEN);
        if (StrUtil.isNotBlank(authToken)) {
            return authToken;
        }

        // 3. 从cookie中获取token
        String sessionCookieName = CookieUtils.getCookie(request, SsoConstant.COOKIE_ACCESS_TOKEN);
        if (StrUtil.isNotBlank(sessionCookieName)) {
            return sessionCookieName;
        }
        return null;
    }

    /**
     * 获取当前登录的用户基本信息
     *
     * @return
     */
    public static SsoUser getUser() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String mToken = getToken();
//        String serverUrl = getServerUrl();
        if (!StrUtil.isAllNotEmpty(serverUrl, mToken)) return null;
        SsoUser user = SessionUtils.getUser(request, mToken);
        if (ObjectUtil.isNotNull(user)) return user;
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(serverUrl, mToken);
        if (result.isSuccess() && ObjectUtil.isNotNull(result.getData())) return result.getData().getUser();
        return null;
    }

    /**
     * 按token 获取当前登录用户信息
     *
     * @param accessToken
     * @return 若没找到用户，或登录过期返回null
     */
    public static SsoUser getUser(String accessToken) {
        HttpServletRequest request = HttpServletUtil.getRequest();
        SsoUser user = SessionUtils.getUser(request, accessToken);
        if (ObjectUtil.isNotNull(user)) return user;
        if (!StrUtil.isAllNotEmpty(serverUrl, accessToken)) return null;
        Result<RpcAccessToken> result = Oauth2Utils.queryAccessToken(serverUrl, accessToken);
        if (result.isSuccess() && ObjectUtil.isNotNull(result.getData())) return result.getData().getUser();
        return null;
    }
}
