package com.geoway.sso.client.util;

import com.alibaba.fastjson.JSONObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import javax.servlet.ServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ALMJ
 * @desc 默认http客户端
 */
public class DefaultHttpClient {

    public Map<String, Object> fetchs(String url, String params, String method, Integer type) throws IOException, URISyntaxException {
        //返回的map
        Map<String, Object> map = new HashMap<>();
        //创建uri对象
        URIBuilder uriBuilder = new URIBuilder(url);
        String res = null;
        //拼凑传递的参数
        if (type == 0) {
            String[] split = params.split(",");
            for (String s : split) {
                String[] values = s.split("=");
                uriBuilder.addParameter(values[0], values[1]);
            }
        }
        //配置
        RequestConfig resquestConfig = RequestConfig.custom()
                .setSocketTimeout(5 * 60 * 1000)
                .setConnectTimeout(60 * 1000)
                .setConnectionRequestTimeout(60 * 1000)
                .build();
        //创建请求的Builder
        RequestBuilder requestBuilder = RequestBuilder.create(method)
                .setUri(uriBuilder.build())
                .setConfig(resquestConfig);
        if (type == 1) {
            requestBuilder.setEntity(new StringEntity(params, "UTF-8"));
            requestBuilder.setHeader("Content-Type", "application/json;charset=UTF-8");
        }
        //建立连接
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            CloseableHttpResponse result = client.execute(requestBuilder.build());
            //连接之后的时间
            //响应消息实体
            HttpEntity entity = result.getEntity();
            //响应头
            for (Header header : result.getAllHeaders()) {
                //所有响应保持长连接
                if (header.equals("connection")) {
                    requestBuilder.setHeader("connection", "keep-alive");
                    requestBuilder.setHeader("keep-alive", "timeout=10");
                }
            }
            //处理返回的map
            String jsons = EntityUtils.toString(entity, "UTF-8");
            map = JSONObject.parseObject(jsons);
            result.close();
            return map;
        } catch (Exception e) {
            if (res == null) {
                String msg = "【" + url + "】该地址连接失败！！！";
                map.put("code", 1000);
                map.put("msg", msg);
                map.put("costTime", 0.0);
            }
            return map;
        } finally {
            client.close();
        }
    }


    /**
     * JSON字符串处理
     *
     * @param is
     * @throws IOException
     */
    public String InputStreamPra(ServletInputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        String s = "";
        while ((s = br.readLine()) != null) {
            sb.append(s);
        }
        return sb.toString();
    }

    /**
     * 获取请求的协议，判断是http 还是https
     *
     * @param reqUrl
     * @return
     */
    public static String getHttpShcema(String reqUrl) {
        String result = "http";
        try {
            URL url = new URL(reqUrl);
            URI uri = url.toURI();
            result = uri.getScheme();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return result;
    }

}
