package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.SessionAccessToken;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.Optional;

/**
 * @author ALMJ
 * @desc Session工具
 */
public class SessionUtils {

    public static SessionAccessToken getAccessToken(HttpServletRequest request, String access_token) {
//        SessionAccessToken sessionAccessToken = (SessionAccessToken) request.getSession().getAttribute(SsoConstant.SESSION_ACCESS_TOKEN);
//        if (sessionAccessToken == null && access_token != null) {
//            sessionAccessToken = (SessionAccessToken) request.getSession().getAttribute(SsoConstant.SESSION_ACCESS_TOKEN + "_" + access_token);
//        }
        SessionAccessToken sessionAccessToken = (SessionAccessToken) request.getSession().getAttribute(SsoConstant.SESSION_ACCESS_TOKEN + "_" + access_token);
        return sessionAccessToken;
    }

    public static SessionAccessToken getAccessSessionToken(HttpServletRequest request) {
        SessionAccessToken sessionAccessToken = (SessionAccessToken) request.getSession().getAttribute(SsoConstant.SESSION_ACCESS_TOKEN);
        return sessionAccessToken;
    }

    public static SsoUser getUser(HttpServletRequest request, String access_token) {
        SessionAccessToken sessionAccessToken = Optional.ofNullable(getAccessToken(request, access_token))
                .orElse(getAccessSessionToken(request));
        if (ObjectUtil.isNotNull(sessionAccessToken)) {
            return sessionAccessToken.getUser();
        } else {
            return null;
        }
    }

    public static String getUserId(HttpServletRequest request) {
        return Optional.ofNullable(getUser(request, null)).map(u -> u.getId()).orElse(null);
    }


    public static void setAccessToken(HttpServletRequest request, RpcAccessToken rpcAccessToken) {
        SessionAccessToken sessionAccessToken = null;
        if (rpcAccessToken != null) {
            sessionAccessToken = createSessionAccessToken(rpcAccessToken);
        }
        //session中存两份accessToken，用来兼容基于session和和cookie的验证
        request.getSession().setAttribute(SsoConstant.SESSION_ACCESS_TOKEN, sessionAccessToken);
        if (sessionAccessToken != null) {
            request.getSession().setAttribute(SsoConstant.SESSION_ACCESS_TOKEN + "_" + sessionAccessToken.getAccessToken(), sessionAccessToken);
        }
    }

    private static SessionAccessToken createSessionAccessToken(RpcAccessToken accessToken) {
        long expirationTime = System.currentTimeMillis() + accessToken.getExpiresIn() * 1000;
        return new SessionAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn(),
                accessToken.getRefreshToken(), accessToken.getUser(), expirationTime);
    }

    public static void invalidate(HttpServletRequest request) {
        setAccessToken(request, null);
        request.getSession().invalidate();
    }
}