package com.geoway.sso.client.util;

import com.geoway.sso.client.constant.SsoConstant;

import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

/**
 * @author ALMJ
 * @desc 客户端用户操作统一封装类
 * @date 2022/1/17 12:59
 */

public class SsoCheckLogin {
    /**
     * 第三方应用授权密钥
     */
    private String serverUrl;

    public SsoCheckLogin(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    /**
     * 统一登出当前用户
     *
     * @param redirectUri 登出后重定向地址
     * @param request     http请求对象
     * @return
     */
    public String userLogut(String redirectUri, HttpServletRequest request) {
        String logoutUrl = null;
        try {
            logoutUrl = this.serverUrl + SsoConstant.LOGOUT_URL + "?" + SsoConstant.REDIRECT_URI + "="
                    + URLEncoder.encode(redirectUri, "utf-8");
            SessionUtils.invalidate(request);
        } catch (Exception ex) {

        }
        return logoutUrl;
    }
}
