package com.geoway.sso.client.util;

import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.session.SessionMappingStorage;
import com.geoway.sso.client.session.redis.RedisSessionMappingStorage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.net.URLEncoder;

/**
 * @author ALMJ
 * @desc 客户端用户操作统一封装类
 * @date 2022/1/17 12:59
 */

public class SsoCheckLoginRedis {
    /**
     * 第三方应用授权密钥
     */
    private String serverUrl;

    public SsoCheckLoginRedis(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Autowired
    private SessionMappingStorage sessionMappingStorage;

    @Bean
    public SessionMappingStorage sessionMappingStorage() {
        return new RedisSessionMappingStorage();
    }

    /**
     * 统一登出当前用户
     *
     * @param redirectUri 登出后重定向地址
     * @param request     http请求对象
     * @return
     */
    public String userLogut(String redirectUri, HttpServletRequest request) {
        String logoutUrl = null;
        try {
            HttpSession session = request.getSession();
            logoutUrl = this.serverUrl + SsoConstant.LOGOUT_URL + "?" + SsoConstant.REDIRECT_URI + "="
                    + URLEncoder.encode(redirectUri, "utf-8");
            sessionMappingStorage.removeBySessionById(session.getId());
            SessionUtils.invalidate(request);
        } catch (Exception ex) {

        }
        return logoutUrl;
    }
}
