/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.session.local;

import com.geoway.sso.client.session.SessionMappingStorage;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"sso.session.manager"}, havingValue="local")
public final class LocalSessionMappingStorage
implements SessionMappingStorage {
    private final Map<String, HttpSession> tokenSessionMap = new HashMap<String, HttpSession>();
    private final Map<String, String> sessionTokenMap = new HashMap<String, String>();

    @Override
    public synchronized void addSessionById(String accessToken, HttpSession session) {
        this.sessionTokenMap.put(session.getId(), accessToken);
        this.tokenSessionMap.put(accessToken, session);
    }

    @Override
    public void addTokenByUserName(String accessToken, String userName) {
        this.sessionTokenMap.put(userName, accessToken);
    }

    @Override
    public void removeTokenByUserName(String userName) {
        this.sessionTokenMap.remove(userName);
    }

    @Override
    public String getTokenByUserName(String userName) {
        return this.sessionTokenMap.get(userName);
    }

    @Override
    public synchronized void removeBySessionById(String sessionId) {
        String accessToken = this.sessionTokenMap.get(sessionId);
        this.tokenSessionMap.remove(accessToken);
        this.sessionTokenMap.remove(sessionId);
    }

    @Override
    public synchronized HttpSession removeSessionByMappingId(String accessToken) {
        HttpSession session = this.tokenSessionMap.get(accessToken);
        if (session != null) {
            this.removeBySessionById(session.getId());
        }
        return session;
    }
}

