/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.session.redis;

import com.geoway.sso.client.session.SessionMappingStorage;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"sso.session.manager"}, havingValue="redis")
public final class RedisSessionMappingStorage
implements SessionMappingStorage {
    private static final String SESSION_TOKEN_KEY = "ns-design-session_token_key_";
    private static final String TOKEN_SESSION_KEY = "ns-design-token_session_key_";
    private static final String TOKEN_USERNAME_KEY = "ns-design-token-user-name-key_";
    @Autowired
    private SessionRepository<?> sessionRepository;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${sso.timeout}")
    private Long timeout;

    @Override
    public synchronized void addSessionById(String accessToken, HttpSession session) {
        this.redisTemplate.opsForValue().set((Object)(SESSION_TOKEN_KEY + session.getId()), (Object)accessToken, this.timeout.longValue(), TimeUnit.SECONDS);
        this.redisTemplate.opsForValue().set((Object)(TOKEN_SESSION_KEY + accessToken), (Object)session.getId(), this.timeout.longValue(), TimeUnit.SECONDS);
    }

    @Override
    public void addTokenByUserName(String accessToken, String userName) {
        this.redisTemplate.opsForValue().set((Object)(TOKEN_USERNAME_KEY + userName), (Object)accessToken, this.timeout.longValue(), TimeUnit.SECONDS);
    }

    @Override
    public void removeTokenByUserName(String userName) {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)(TOKEN_USERNAME_KEY + userName));
        if (accessToken != null) {
            this.redisTemplate.delete((Object)(TOKEN_USERNAME_KEY + userName));
        }
    }

    @Override
    public String getTokenByUserName(String userName) {
        return (String)this.redisTemplate.opsForValue().get((Object)(TOKEN_USERNAME_KEY + userName));
    }

    @Override
    public synchronized void removeBySessionById(String sessionId) {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)(SESSION_TOKEN_KEY + sessionId));
        if (accessToken != null) {
            this.redisTemplate.delete((Object)(TOKEN_SESSION_KEY + accessToken));
            this.redisTemplate.delete((Object)(SESSION_TOKEN_KEY + sessionId));
            this.sessionRepository.deleteById(sessionId);
        }
    }

    @Override
    public synchronized HttpSession removeSessionByMappingId(String accessToken) {
        String sessionId = (String)this.redisTemplate.opsForValue().get((Object)(TOKEN_SESSION_KEY + accessToken));
        if (sessionId != null) {
            this.removeBySessionById(sessionId);
        }
        return null;
    }
}

