/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpServletUtil.class);
    private static final String LOCAL_IP = "127.0.0.1";
    private static final String AGENT_SOURCE_IP = "Agent-Source-Ip";
    private static final String LOCAL_REMOTE_HOST = "0:0:0:0:0:0:0:1";
    private static final String USER_AGENT_HTTP_HEADER = "User-Agent";

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RuntimeException("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
        }
        return requestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RuntimeException("\u83b7\u53d6\u54cd\u5e94\u53c2\u6570\u5931\u8d25");
        }
        return requestAttributes.getResponse();
    }

    public static String getRequestClientIp(HttpServletRequest request) {
        if (ObjectUtil.isEmpty((Object)request)) {
            return LOCAL_IP;
        }
        String remoteHost = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[]{AGENT_SOURCE_IP});
        return LOCAL_REMOTE_HOST.equals(remoteHost) ? LOCAL_IP : remoteHost;
    }

    public static UserAgent getUserAgent(HttpServletRequest request) {
        String userAgentStr = ServletUtil.getHeaderIgnoreCase((HttpServletRequest)request, (String)USER_AGENT_HTTP_HEADER);
        if (ObjectUtil.isNotEmpty((Object)userAgentStr)) {
            return UserAgentUtil.parse((String)userAgentStr);
        }
        return null;
    }

    public static Boolean getNormalRequestFlag(HttpServletRequest request) {
        return request.getHeader("Accept") == null || request.getHeader("Accept").toLowerCase().contains("text/html");
    }

    public static Boolean getJsonRequestFlag(HttpServletRequest request) {
        return request.getHeader("Accept") == null || request.getHeader("Accept").toLowerCase().contains("application/json");
    }
}

