/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> paramMap) {
        String result = null;
        CloseableHttpResponse response = null;
        String realUrl = url;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpGet httpGet;
            if (paramMap != null && !paramMap.isEmpty()) {
                ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                    params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                String paramStr = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                realUrl = realUrl + "?" + paramStr;
            }
            if ((response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(realUrl)))) != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                logger.info("url: {}, result: {}", (Object)url, (Object)result);
            }
            Iterator<Map.Entry<String, String>> iterator = result;
            return iterator;
        }
        catch (Exception e) {
            logger.error("url: {}, result: {}", new Object[]{url, result, e});
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static String get(String url) {
        return HttpUtils.get(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> paramMap, Map<String, String> headerMap) {
        HttpPost httpPost = null;
        CloseableHttpClient httpClient = null;
        try {
            CloseableHttpResponse response;
            HttpEntity entity;
            httpPost = new HttpPost(url);
            if (paramMap != null && !paramMap.isEmpty()) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            }
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build();
            httpPost.setConfig(requestConfig);
            if (headerMap != null && !headerMap.isEmpty()) {
                for (Map.Entry<String, String> headerItem : headerMap.entrySet()) {
                    httpPost.setHeader(headerItem.getKey(), headerItem.getValue());
                }
            }
            if ((entity = (response = (httpClient = HttpClients.custom().disableAutomaticRetries().build()).execute((HttpUriRequest)httpPost)).getEntity()) != null && response.getStatusLine().getStatusCode() == 200) {
                String result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
                logger.info("url: {}, result: {}", (Object)url, (Object)result);
                String string = result;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            logger.error("url: {}, paramMap: {}", new Object[]{url, paramMap, e});
            Iterator<Map.Entry<String, String>> iterator = null;
            return iterator;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public static String post(String url, Map<String, String> paramMap) {
        return HttpUtils.post(url, paramMap, null);
    }

    public static String postHeader(String url, Map<String, String> headerMap) {
        return HttpUtils.post(url, null, headerMap);
    }
}

