/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.SessionAccessToken;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class SessionUtils {
    public static SessionAccessToken getAccessToken(HttpServletRequest request, String access_token) {
        SessionAccessToken sessionAccessToken = (SessionAccessToken)request.getSession().getAttribute("_sessionAccessToken_" + access_token);
        return sessionAccessToken;
    }

    public static SessionAccessToken getAccessSessionToken(HttpServletRequest request) {
        SessionAccessToken sessionAccessToken = (SessionAccessToken)request.getSession().getAttribute("_sessionAccessToken");
        return sessionAccessToken;
    }

    public static SsoUser getUser(HttpServletRequest request, String access_token) {
        SessionAccessToken sessionAccessToken = Optional.ofNullable(SessionUtils.getAccessToken(request, access_token)).orElse(SessionUtils.getAccessSessionToken(request));
        if (ObjectUtil.isNotNull((Object)sessionAccessToken)) {
            return sessionAccessToken.getUser();
        }
        return null;
    }

    public static String getUserId(HttpServletRequest request) {
        return Optional.ofNullable(SessionUtils.getUser(request, null)).map(u -> u.getId()).orElse(null);
    }

    public static void setAccessToken(HttpServletRequest request, RpcAccessToken rpcAccessToken) {
        SessionAccessToken sessionAccessToken = null;
        if (rpcAccessToken != null) {
            sessionAccessToken = SessionUtils.createSessionAccessToken(rpcAccessToken);
        }
        request.getSession().setAttribute("_sessionAccessToken", (Object)sessionAccessToken);
        if (sessionAccessToken != null) {
            request.getSession().setAttribute("_sessionAccessToken_" + sessionAccessToken.getAccessToken(), (Object)sessionAccessToken);
        }
    }

    private static SessionAccessToken createSessionAccessToken(RpcAccessToken accessToken) {
        long expirationTime = System.currentTimeMillis() + (long)(accessToken.getExpiresIn() * 1000);
        return new SessionAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn(), accessToken.getRefreshToken(), accessToken.getUser(), expirationTime);
    }

    public static void invalidate(HttpServletRequest request) {
        SessionUtils.setAccessToken(request, null);
        request.getSession().invalidate();
    }
}

