/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import com.geoway.sso.client.session.SessionMappingStorage;
import com.geoway.sso.client.session.redis.RedisSessionMappingStorage;
import com.geoway.sso.client.util.SessionUtils;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;

public class SsoCheckLoginRedis {
    private String serverUrl;
    @Autowired
    private SessionMappingStorage sessionMappingStorage;

    public SsoCheckLoginRedis(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Bean
    public SessionMappingStorage sessionMappingStorage() {
        return new RedisSessionMappingStorage();
    }

    public String userLogut(String redirectUri, HttpServletRequest request) {
        String logoutUrl = null;
        try {
            HttpSession session = request.getSession();
            logoutUrl = this.serverUrl + "/logout" + "?" + "redirectUri" + "=" + URLEncoder.encode(redirectUri, "utf-8");
            this.sessionMappingStorage.removeBySessionById(session.getId());
            SessionUtils.invalidate(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logoutUrl;
    }
}

