/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.util.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2Utils {
    private static final Logger logger = LoggerFactory.getLogger(Oauth2Utils.class);

    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password, String tel) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.PASSWORD.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("username", username);
        paramMap.put("password", password);
        paramMap.put("tel", tel);
        return Oauth2Utils.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    public static Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String code) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grantType", GrantTypeEnum.AUTHORIZATION_CODE.getValue());
        paramMap.put("appId", appId);
        paramMap.put("appSecret", appSecret);
        paramMap.put("code", code);
        return Oauth2Utils.getHttpAccessToken(serverUrl + "/oauth2/access_token", paramMap);
    }

    public static Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appId", appId);
        paramMap.put("refreshToken", refreshToken);
        return Oauth2Utils.getHttpAccessToken(serverUrl + "/oauth2/refresh_token", paramMap);
    }

    public static Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("access_token", accessToken);
        return Oauth2Utils.getHttpAccessToken(serverUrl + "/oauth2/query_access_token", paramMap);
    }

    public static Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("access_token", accessToken);
        return Oauth2Utils.getHttpAccessToken(serverUrl + "/oauth2/revoke_access_token", paramMap);
    }

    public static Result<RpcAccessToken> getHttpAccessToken(String url, Map<String, String> paramMap) {
        String jsonStr = HttpUtils.get(url, paramMap);
        if (jsonStr == null || jsonStr.isEmpty()) {
            logger.error("getHttpAccessToken exception, return null. url:{}", (Object)url);
            return null;
        }
        return (Result)JSONObject.parseObject((String)jsonStr, (TypeReference)new TypeReference<Result<RpcAccessToken>>(){}, (Feature[])new Feature[0]);
    }
}

