/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.client.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.session.SessionAccessToken;
import com.geoway.sso.client.util.StringUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.ServletRequestHandledEvent;

@Component
public class SessionUtils
implements ApplicationListener<ServletRequestHandledEvent> {
    private static RedisTemplate<String, String> redisTemplate;
    private static ThreadLocal<SessionAccessToken> localAccessSession;

    @Autowired
    public SessionUtils(RedisTemplate<String, String> redisTemplate) {
        SessionUtils.redisTemplate = redisTemplate;
    }

    public static SessionAccessToken getAccessToken(HttpServletRequest request, String access_token) {
        if (localAccessSession.get() != null) {
            return localAccessSession.get();
        }
        String atcStr = (String)redisTemplate.opsForValue().get((Object)("_sessionAccessToken_" + access_token));
        if (StringUtils.isEmpty(atcStr)) {
            return null;
        }
        SessionAccessToken sessionAccessToken = (SessionAccessToken)JSONObject.parseObject((String)atcStr, SessionAccessToken.class);
        localAccessSession.set(sessionAccessToken);
        return sessionAccessToken;
    }

    public static SessionAccessToken getAccessSessionToken(HttpServletRequest request) {
        SessionAccessToken sessionAccessToken = (SessionAccessToken)request.getSession().getAttribute("_sessionAccessToken");
        return sessionAccessToken;
    }

    public static SsoUser getUser(HttpServletRequest request, String access_token) {
        SessionAccessToken sessionAccessToken = SessionUtils.getAccessToken(request, access_token);
        if (ObjectUtil.isNotNull((Object)sessionAccessToken)) {
            return sessionAccessToken.getUser();
        }
        return null;
    }

    public static String getUserId(HttpServletRequest request) {
        return Optional.ofNullable(SessionUtils.getUser(request, null)).map(u -> u.getId()).orElse(null);
    }

    public static void setAccessToken(HttpServletRequest request, RpcAccessToken rpcAccessToken) {
        SessionAccessToken sessionAccessToken = null;
        if (rpcAccessToken != null) {
            sessionAccessToken = SessionUtils.createSessionAccessToken(rpcAccessToken);
        }
        localAccessSession.set(sessionAccessToken);
        if (sessionAccessToken != null) {
            redisTemplate.opsForValue().set((Object)("_sessionAccessToken_" + sessionAccessToken.getAccessToken()), (Object)JSONObject.toJSONString((Object)sessionAccessToken));
        }
    }

    private static SessionAccessToken createSessionAccessToken(RpcAccessToken accessToken) {
        long expirationTime = System.currentTimeMillis() + (long)(accessToken.getExpiresIn() / 2 * 1000);
        return new SessionAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn(), accessToken.getRefreshToken(), accessToken.getUser(), expirationTime);
    }

    public static void invalidate(String access_token) {
        redisTemplate.delete((Object)("_sessionAccessToken_" + access_token));
    }

    public static void invalidate(HttpServletRequest request) {
        SessionAccessToken sessionAccessToken = SessionUtils.getAccessSessionToken(request);
        if (sessionAccessToken != null) {
            redisTemplate.delete((Object)("_sessionAccessToken_" + sessionAccessToken.getAccessToken()));
        }
        request.getSession().invalidate();
    }

    public void onApplicationEvent(ServletRequestHandledEvent event) {
        localAccessSession.set(null);
    }

    static {
        localAccessSession = new ThreadLocal();
    }
}

