/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="redis")
public class RedisAccessTokenManager
implements AccessTokenManager {
    @Value(value="${sso.timeout}")
    private int timeout;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    final String KEY_ONLINE_USER = "UserMonitor";

    @Override
    public void create(String accessToken, AccessTokenContent accessTokenContent) {
        this.redisTemplate.opsForValue().set((Object)("SSO_" + accessToken), (Object)JSON.toJSONString((Object)accessTokenContent), (long)this.getExpiresIn(), TimeUnit.SECONDS);
        String addKey = "SSO_" + this.getKey(accessTokenContent.getCodeContent().getTgt());
        this.redisTemplate.opsForSet().add((Object)addKey, (Object[])new String[]{accessToken});
        this.redisTemplate.expire((Object)addKey, (long)this.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public AccessTokenContent get(String accessToken) {
        String atcStr = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + accessToken));
        if (StringUtils.isEmpty((Object)atcStr)) {
            return null;
        }
        return (AccessTokenContent)JSONObject.parseObject((String)atcStr, AccessTokenContent.class);
    }

    @Override
    public boolean refresh(String accessToken) {
        if (this.redisTemplate.opsForValue().get((Object)("SSO_" + accessToken)) == null) {
            return false;
        }
        this.redisTemplate.expire((Object)("SSO_" + accessToken), (long)this.timeout, TimeUnit.SECONDS);
        return true;
    }

    @Override
    public void remove(String tgt) {
        Set accessTokenSet = this.redisTemplate.opsForSet().members((Object)("SSO_" + this.getKey(tgt)));
        if (CollectionUtils.isEmpty((Collection)accessTokenSet)) {
            return;
        }
        this.redisTemplate.delete((Object)("SSO_" + this.getKey(tgt)));
        accessTokenSet.forEach(accessToken -> {
            String atcStr = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + accessToken));
            this.redisTemplate.delete((Object)("SSO_" + accessToken));
            this.redisTemplate.opsForList().remove((Object)"UserMonitor", 0L, accessToken);
            if (StringUtils.isEmpty((Object)atcStr)) {
                return;
            }
            AccessTokenContent accessTokenContent = (AccessTokenContent)JSONObject.parseObject((String)atcStr, AccessTokenContent.class);
            if (accessTokenContent == null || !accessTokenContent.getCodeContent().isSendLogoutRequest()) {
                return;
            }
            this.sendLogoutRequest(accessTokenContent.getCodeContent().getRedirectUri(), (String)accessToken);
        });
    }

    private String getKey(String tgt) {
        return tgt + "_access_token";
    }

    @Override
    public int getExpiresIn() {
        return this.timeout / 2;
    }
}

