/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="redis")
public class RedisTicketGrantingTicketManager
implements TicketGrantingTicketManager {
    @Value(value="${sso.timeout}")
    private int timeout;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String tgt, SsoUser user) {
        this.redisTemplate.opsForValue().set((Object)("SSO_" + tgt), (Object)JSON.toJSONString((Object)user), (long)this.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public SsoUser getAndRefresh(String tgt) {
        String user = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + tgt));
        if (StringUtils.isEmpty((Object)user)) {
            return null;
        }
        this.redisTemplate.expire((Object)("SSO_" + tgt), (long)this.timeout, TimeUnit.SECONDS);
        return (SsoUser)JSONObject.parseObject((String)user, SsoUser.class);
    }

    @Override
    public void set(String tgt, SsoUser user) {
        this.create(tgt, user);
    }

    @Override
    public void remove(String tgt) {
        this.redisTemplate.delete((Object)("SSO_" + tgt));
    }

    @Override
    public int getExpiresIn() {
        return this.timeout;
    }
}

