package com.geoway.sso.server.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 配置全局实体类
 *
 * @author: ALMJ
 * @Date: 2021/11/11
 */
@Component
public class PropertyConfig {

    /**
     * 启动模式， 开发模式登录验证码、接口文档等会放开
     */
    @Value("${server.mode}")
    private String runMode;
    /**
     * https 启动端口
     */
    @Value("${server.port}")
    private String serverHttpPort;

    /**
     * 服务http启动端口
     */
    @Value("${server.port}")
    private String serverPort;

    /**
     * sso单点登录是否开启
     */
    @Value("${sso.enable}")
    private String ssoEnable;

    /**
     * 单点登录用户令牌过期时间
     */
    @Value("${sso.timeout:7200}")
    private int ssoTimeout;

    /**
     * 单点登录开关
     */
    @Value("${sso.server.url}")
    private String ssoHttpUrl;

    /**
     * 单点登录https地址
     */
//    @Value("${sso.server.https-url}")
//    private String ssoHttpsUrl;


    /**
     * 单点登录成功后回调接口地址(客户端提供)
     */
    @Value("${sso.app.loginApi}")
    private String ssoAppLoginApi;

    /**
     * 客户端继承时应用备案id
     */
    @Value("${sso.app.id}")
    private String ssoAppId;

    /**
     * 应用备案授权码
     */
    @Value("${sso.app.secret}")
    private String ssoAppSecret;

    /**
     * 登陆页模板名称,如login2.html 则 /login2，userLogin
     */
    @Value("${sso.setting.login-path}")
    private String loginPath;
    public String getRunMode() {
        return runMode;
    }



    public String getServerHttpPort() {
        return serverHttpPort;
    }



    public String getServerPort() {
        return serverPort;
    }



    public String getSsoEnable() {
        return ssoEnable;
    }



    public int getSsoTimeout() {
        if(ssoTimeout<=0){
            return Integer.MAX_VALUE;
        }
        return ssoTimeout;
    }



    public String getSsoHttpUrl() {
        return ssoHttpUrl;
    }



    public String getSsoAppLoginApi() {
        return ssoAppLoginApi;
    }



    public String getSsoAppId() {
        return ssoAppId;
    }



    public String getSsoAppSecret() {
        return ssoAppSecret;
    }



    public String getLoginPath() {
        return loginPath;
    }



}
