package com.geoway.sso.server.session;


import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpUtils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.Expiration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @author ALMJ
 * @desc 调用凭证AccessToken管理抽象
 */
public interface AccessTokenManager extends Expiration {

    /**
     * 生成AccessToken
     *
     * @param accessTokenContent
     * @return
     */
    default String generate(AccessTokenContent accessTokenContent) {
        String accessToken="AT-" + UUID.randomUUID().toString().replaceAll("-", "");
        if(accessTokenContent.getUser()!=null){
            accessToken=StrUtil.isNotBlank(accessTokenContent.getUser().getToken())?
                    accessTokenContent.getUser().getToken():accessToken;
            accessTokenContent.getUser().setToken(accessToken);
        }
        create(accessToken, accessTokenContent);
        return accessToken;
    }

    /**
     * 生成AccessToken
     *
     * @param accessToken
     * @param accessTokenContent
     */
    void create(String accessToken, AccessTokenContent accessTokenContent);

    /**
     * 延长AccessToken生命周期
     *
     * @param accessToken
     * @return
     */
    boolean refresh(String accessToken);

    /**
     * 查询
     *
     * @param accessToken
     * @return
     */
    AccessTokenContent get(String accessToken);

    /**
     * 根据TGT删除AccessToken
     *
     * @param tgt
     */
    void remove(String tgt);

    /**
     *
     * @return
     */
    List<SsoUser> getOnlineUsers();
    /**
     * 发起客户端登出请求
     *
     * @param redirectUri
     * @param accessToken
     */
    default void sendLogoutRequest(String redirectUri, String accessToken) {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put(SsoConstant.LOGOUT_PARAMETER_NAME, accessToken);
        HttpUtils.postHeader(redirectUri, headerMap);
    }

    String getAccessTokenByUserId(String userId);

    void removeOnlineUser(String userId);

    void removeToken(String token);
}
