package com.geoway.sso.server.session.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.constant.AppConstant;
import com.geoway.sso.server.session.CodeManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.concurrent.TimeUnit;

/**
 * @author ALMJ
 * @desc 分布式授权码管理
 */
@Component
@ConditionalOnProperty(name = "sso.session.manager", havingValue = "redis")
public class RedisCodeManager implements CodeManager {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String code, CodeContent codeContent) {
        redisTemplate.opsForValue().set(AppConstant.REDIS_TOKEN_PREFIX + code, JSON.toJSONString(codeContent), getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public CodeContent getAndRemove(String code) {
        String cc = redisTemplate.opsForValue().get(AppConstant.REDIS_TOKEN_PREFIX + code);
        if (!StringUtils.isEmpty(cc)) {
            redisTemplate.delete(AppConstant.REDIS_TOKEN_PREFIX + code);
        }
        return JSONObject.parseObject(cc, CodeContent.class);
    }
}
