/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.local;

import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.common.ExpirationPolicy;
import com.geoway.sso.server.session.CodeManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="local")
public class LocalCodeManager
implements CodeManager,
ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, DummyCode> codeMap = new ConcurrentHashMap<String, DummyCode>();

    @Override
    public void create(String code, CodeContent codeContent) {
        this.codeMap.put(code, new DummyCode(codeContent, System.currentTimeMillis() + (long)(this.getExpiresIn() * 1000)));
        this.logger.info("\u6388\u6743\u7801\u751f\u6210\u6210\u529f, code:{}", (Object)code);
    }

    @Override
    public CodeContent getAndRemove(String code) {
        DummyCode dc = this.codeMap.remove(code);
        if (dc == null || System.currentTimeMillis() > dc.expired) {
            return null;
        }
        return dc.codeContent;
    }

    @Override
    @Scheduled(cron="0 */5 * * * ?")
    public void verifyExpired() {
        this.codeMap.forEach((code, dummyCode) -> {
            if (System.currentTimeMillis() > ((DummyCode)dummyCode).expired) {
                this.codeMap.remove(code);
                this.logger.info("\u6388\u6743\u7801\u5df2\u5931\u6548, code:{}", code);
            }
        });
    }

    private class DummyCode {
        private CodeContent codeContent;
        private long expired;

        public DummyCode(CodeContent codeContent, long expired) {
            this.codeContent = codeContent;
            this.expired = expired;
        }
    }
}

