package com.geoway.sso.server.config;

import com.geoway.sso.server.constant.AppConstant;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.util.Properties;

/**
 * @author ALMJ
 * @desc 验证码配置
 * @date
 */
@Component
public class KaptchaConfig {
    private final static String CODE_LENGTH = "4";

    @Bean
    public DefaultKaptcha defaultKaptcha() {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        Properties properties = new Properties();

        //验证码背景颜色渐变，开始颜色
        properties.setProperty("kaptcha.background.clear.from", "248,248,248");
        // 验证码背景颜色渐变，结束颜色
        properties.setProperty("kaptcha.background.clear.to", "248,248,248");
        // 设置边框
        properties.setProperty("kaptcha.border", "no");
        // 设置边框颜色
        properties.setProperty("kaptcha.border.color", "105,179,90");
        // 设置字体颜色
        properties.setProperty("kaptcha.textproducer.font.color", "0,0,255");
        //验证码文字间距
        properties.setProperty("kaptcha.textproducer.char.space", "4");
        // 设置图片宽度
        properties.setProperty("kaptcha.image.width", "100");
        // 设置图片高度
        properties.setProperty("kaptcha.image.height", "36");
        // 设置字体尺寸
        properties.setProperty("kaptcha.textproducer.font.size", "32");
        // 设置session key
        properties.setProperty("kaptcha.session.key", AppConstant.CAPTCHA_SESSION_IMAGE);
        //验证码的字符
        properties.setProperty("kaptcha.textproducer.char.string", "023456789abcdefghjkmnopqrstuvwxyz");
        // 设置验证码长度
        properties.setProperty("kaptcha.textproducer.char.length", CODE_LENGTH);
        // 设置字体
        properties.setProperty("kaptcha.textproducer.font.names", "宋体,楷体,黑体");
        Config config = new Config(properties);
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }
}
