/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.server.common.RefreshTokenContent;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.RefreshTokenManager;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="redis")
public class RedisRefreshTokenManager
implements RefreshTokenManager {
    @Autowired
    private PropertyConfig propertyConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String refreshToken, RefreshTokenContent refreshTokenContent) {
        this.redisTemplate.opsForValue().set((Object)("SSO_" + refreshToken), (Object)JSON.toJSONString((Object)refreshTokenContent), (long)this.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public RefreshTokenContent validate(String refreshToken) {
        String rtc = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + refreshToken));
        return (RefreshTokenContent)JSONObject.parseObject((String)rtc, RefreshTokenContent.class);
    }

    @Override
    public int getExpiresIn() {
        return this.propertyConfig.getSsoTimeout();
    }
}

