/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.redis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.session.CodeManager;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="redis")
public class RedisCodeManager
implements CodeManager {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String code, CodeContent codeContent) {
        this.redisTemplate.opsForValue().set((Object)("SSO_" + code), (Object)JSON.toJSONString((Object)codeContent), (long)this.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public CodeContent getAndRemove(String code) {
        String cc = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + code));
        if (!StringUtils.isEmpty((Object)cc)) {
            this.redisTemplate.delete((Object)("SSO_" + code));
        }
        return (CodeContent)JSONObject.parseObject((String)cc, CodeContent.class);
    }

    @Override
    public CodeContent get(String code) {
        String cc = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + code));
        return (CodeContent)JSONObject.parseObject((String)cc, CodeContent.class);
    }
}

