/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PropertyConfig {
    @Value(value="${server.mode}")
    private String runMode;
    @Value(value="${server.port}")
    private String serverHttpPort;
    @Value(value="${server.port}")
    private String serverPort;
    @Value(value="${sso.enable}")
    private String ssoEnable;
    @Value(value="${sso.timeout:7200}")
    private int ssoTimeout;
    @Value(value="${sso.server.url:}")
    private String ssoHttpUrl;
    @Value(value="${sso.app.loginApi}")
    private String ssoAppLoginApi;
    @Value(value="${sso.app.id}")
    private String ssoAppId;
    @Value(value="${sso.app.secret}")
    private String ssoAppSecret;
    @Value(value="${sso.setting.login-path}")
    private String loginPath;
    @Value(value="${sso.setting.singeUser:false}")
    private Boolean singeUser;

    public String getRunMode() {
        return this.runMode;
    }

    public String getServerHttpPort() {
        return this.serverHttpPort;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getSsoEnable() {
        return this.ssoEnable;
    }

    public int getSsoTimeout() {
        if (this.ssoTimeout <= 0) {
            return Integer.MAX_VALUE;
        }
        return this.ssoTimeout;
    }

    public String getSsoHttpUrl() {
        return this.ssoHttpUrl;
    }

    public String getSsoAppLoginApi() {
        return this.ssoAppLoginApi;
    }

    public String getSsoAppId() {
        return this.ssoAppId;
    }

    public String getSsoAppSecret() {
        return this.ssoAppSecret;
    }

    public String getLoginPath() {
        return this.loginPath;
    }

    public Boolean getSingeUser() {
        return this.singeUser;
    }

    public void setSingeUser(Boolean singeUser) {
        this.singeUser = singeUser;
    }
}

