/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.local;

import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.common.ExpirationPolicy;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="local")
public class LocalAccessTokenManager
implements AccessTokenManager,
ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PropertyConfig propertyConfig;
    private Map<String, DummyAccessToken> accessTokenMap = new ConcurrentHashMap<String, DummyAccessToken>();
    private Map<String, Set<String>> tgtMap = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public void create(String accessToken, AccessTokenContent accessTokenContent) {
        DummyAccessToken dat = new DummyAccessToken(accessTokenContent, System.currentTimeMillis() + (long)(this.getExpiresIn() * 1000));
        this.accessTokenMap.put(accessToken, dat);
        this.tgtMap.computeIfAbsent(accessTokenContent.getCodeContent().getTgt(), a -> new HashSet()).add(accessToken);
        this.logger.info("\u8c03\u7528\u51ed\u8bc1\u751f\u6210\u6210\u529f, accessToken:{}", (Object)accessToken);
    }

    @Override
    public AccessTokenContent get(String accessToken) {
        DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
        if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
            return null;
        }
        return dummyAt.accessTokenContent;
    }

    @Override
    public boolean refresh(String accessToken) {
        DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
        if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
            return false;
        }
        dummyAt.expired = System.currentTimeMillis() + (long)(this.getExpiresIn() * 1000);
        return true;
    }

    @Override
    public void remove(String tgt) {
        Set<String> accessTokenSet = this.tgtMap.remove(tgt);
        if (CollectionUtils.isEmpty(accessTokenSet)) {
            return;
        }
        accessTokenSet.forEach(accessToken -> {
            DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
            if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
                return;
            }
            CodeContent codeContent = dummyAt.accessTokenContent.getCodeContent();
            if (codeContent == null || !codeContent.isSendLogoutRequest()) {
                return;
            }
            this.logger.debug("\u53d1\u8d77\u5ba2\u6237\u7aef\u767b\u51fa\u8bf7\u6c42, accessToken:{}, url:{}", accessToken, (Object)codeContent.getRedirectUri());
            this.sendLogoutRequest(codeContent.getRedirectUri(), (String)accessToken);
        });
    }

    @Override
    public List<SsoUser> getOnlineUsers() {
        return null;
    }

    @Override
    public String getAccessTokenByUserId(String userId) {
        String accessToken = null;
        for (String key : this.accessTokenMap.keySet()) {
            AccessTokenContent tokenContent = this.get(key);
            if (tokenContent == null || !tokenContent.getUser().getId().equals(userId)) continue;
            accessToken = key;
            break;
        }
        return accessToken;
    }

    @Override
    public void removeOnlineUser(String userId) {
        String accessToken = this.getAccessTokenByUserId(userId);
        if (StrUtil.isNotBlank((CharSequence)accessToken)) {
            this.removeToken(accessToken);
        }
    }

    @Override
    public void removeToken(String token) {
        if (StrUtil.isNotBlank((CharSequence)token)) {
            this.accessTokenMap.remove(token);
        }
    }

    @Override
    @Scheduled(cron="0 */5 * * * ?")
    public void verifyExpired() {
        this.accessTokenMap.forEach((accessToken, dummyAt) -> {
            if (System.currentTimeMillis() > ((DummyAccessToken)dummyAt).expired) {
                this.accessTokenMap.remove(accessToken);
                this.logger.debug("\u8c03\u7528\u51ed\u8bc1\u5df2\u5931\u6548, accessToken:{}", accessToken);
            }
        });
    }

    @Override
    public int getExpiresIn() {
        return this.propertyConfig.getSsoTimeout() / 2;
    }

    private class DummyAccessToken {
        private AccessTokenContent accessTokenContent;
        private long expired;

        public DummyAccessToken(AccessTokenContent accessTokenContent, long expired) {
            this.accessTokenContent = accessTokenContent;
            this.expired = expired;
        }
    }
}

