/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.local;

import com.geoway.sso.server.common.ExpirationPolicy;
import com.geoway.sso.server.common.RefreshTokenContent;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.RefreshTokenManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="local")
public class LocalRefreshTokenManager
implements RefreshTokenManager,
ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PropertyConfig propertyConfig;
    private Map<String, DummyRefreshToken> refreshTokenMap = new ConcurrentHashMap<String, DummyRefreshToken>();

    @Override
    public void create(String refreshToken, RefreshTokenContent refreshTokenContent) {
        DummyRefreshToken dummyRt = new DummyRefreshToken(refreshTokenContent, System.currentTimeMillis() + (long)(this.getExpiresIn() * 1000));
        this.refreshTokenMap.put(refreshToken, dummyRt);
    }

    @Override
    public RefreshTokenContent validate(String rt) {
        DummyRefreshToken dummyRt = this.refreshTokenMap.remove(rt);
        if (dummyRt == null || System.currentTimeMillis() > dummyRt.expired) {
            return null;
        }
        return dummyRt.refreshTokenContent;
    }

    @Override
    @Scheduled(cron="0 */5 * * * ?")
    public void verifyExpired() {
        this.refreshTokenMap.forEach((resfreshToken, dummyRt) -> {
            if (System.currentTimeMillis() > ((DummyRefreshToken)dummyRt).expired) {
                this.refreshTokenMap.remove(resfreshToken);
                this.logger.debug("resfreshToken : " + resfreshToken + "\u5df2\u5931\u6548");
            }
        });
    }

    @Override
    public int getExpiresIn() {
        return this.propertyConfig.getSsoTimeout();
    }

    private class DummyRefreshToken {
        private RefreshTokenContent refreshTokenContent;
        private long expired;

        public DummyRefreshToken(RefreshTokenContent refreshTokenContent, long expired) {
            this.refreshTokenContent = refreshTokenContent;
            this.expired = expired;
        }
    }
}

