/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.ns.ai.base.chat.dto.AiChatDTO;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.base.tool.http.AiHttpToolCallRequest;
import com.geoway.ns.ai.base.tool.http.AiHttpToolExcuteServiceImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.publisher.Flux;

@Component
@Primary
public class XxptAiHttpToolExcuteServiceImpl
extends AiHttpToolExcuteServiceImpl {
    private Map<String, LoginUserInfo> userInfoMap = new ConcurrentHashMap<String, LoginUserInfo>();
    private Map<String, RequestAttributes> attributesMap = new ConcurrentHashMap<String, RequestAttributes>();
    @Resource
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AiToolResult chat(AiHttpToolCallRequest aiHttpToolCallRequest, Consumer<AiMessage> messageConsumer) {
        AiToolContext aiToolContext = new AiToolContext(aiHttpToolCallRequest.getToolContext());
        AiChatDTO aiChatDTO = (AiChatDTO)aiToolContext.get("TOOL_CALL_CHAT_DTO", AiChatDTO.class);
        try {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.attributesMap.get(aiChatDTO.getUuid()));
            ThreadLocalUtil.addCurrentUser((LoginUserInfo)this.userInfoMap.get(aiChatDTO.getUuid()));
            AiToolResult aiToolResult = super.chat(aiHttpToolCallRequest, messageConsumer);
            return aiToolResult;
        }
        finally {
            this.userInfoMap.remove(aiChatDTO.getUuid());
            this.attributesMap.remove(aiChatDTO.getUuid());
        }
    }

    public Flux<ServerSentEvent<AiMessage>> callStream(AiHttpToolCallRequest aiHttpToolCallRequest) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserService.getUserInfo(requestAttributes.getRequest());
        AiToolContext aiToolContext = new AiToolContext(aiHttpToolCallRequest.getToolContext());
        AiChatDTO aiChatDTO = (AiChatDTO)aiToolContext.get("TOOL_CALL_CHAT_DTO", AiChatDTO.class);
        this.userInfoMap.put(aiChatDTO.getUuid(), loginUserInfo);
        this.attributesMap.put(aiChatDTO.getUuid(), (RequestAttributes)requestAttributes);
        return super.callStream(aiHttpToolCallRequest);
    }
}

