/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.aisql;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateUtil;
import cn.hutool.json.JSONUtil;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AiSystemMessage;
import com.geoway.ns.ai.base.chat.message.AiUserMessage;
import com.geoway.ns.ai.base.tool.AiBaseTool;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.tool.aigeometry.AiGeometryToolCallResult;
import com.geoway.ns.ai.tool.aisql.AiSqlToolCallResult;
import com.geoway.ns.ai.tool.aisql.AiSqlToolDefinition;
import com.geoway.ns.ai.tool.aisql.AiSqlToolParam;
import com.geoway.ns.ai.tool.dto.AiCatalogDataNodeDTO;
import com.geoway.ns.ai.tool.dto.AiSqlResultDTO;
import com.geoway.ns.ai.tool.util.AICatalogNodeUtil;
import com.geoway.ns.ai.tool.util.AIGeometryToolUtil;
import com.geoway.ns.ai.tool.util.AIReturnContentUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AiSqlTool
extends AiBaseTool<AiSqlToolParam, AiSqlToolDefinition> {
    private AppCatalogNodeService appCatalogNodeService = (AppCatalogNodeService)SpringContextUtil.getBean(AppCatalogNodeService.class);
    private static final String KEY_MESSAGE_SQL = "KEY_MESSAGE_SQL";
    private static final String ROLE_PROMPT = "\u89d2\u8272\u4efb\u52a1\uff1a\u4f5c\u4e3aPostgreSQL\u6570\u636e\u5e93\u5b89\u5168\u4e13\u5bb6\uff0c\u60a8\u5fc5\u987b\u5c06\u7528\u6237\u95ee\u9898\u4e25\u683c\u8f6c\u6362\u4e3a\u53ea\u8bfbSQL\u67e5\u8be2\u8bed\u53e5\uff08\u4ec5\u9650SELECT\u64cd\u4f5c\uff0c\u7981\u6b62\u4efb\u4f55\u5199\u5165\u6216\u4fee\u6539\u64cd\u4f5c\uff09,\u8f6c\u6362\u8fc7\u7a0b\u9700\u5b9e\u65bd\u4e3b\u52a8\u9632\u5fa1\u63aa\u65bd\u4ee5\u675c\u7eddSQL\u6ce8\u5165\u98ce\u9669\u3002";
    private static final String RETURN_PROMPT = "\u8fd4\u56de\u5185\u5bb9\u8981\u6c42\n  -\u8f93\u51fa\u5b8c\u6574\u7684SQL\u8bed\u53e5\u53ca\u88ab\u67e5\u8be2\u7684\u8868\u540d\u5217\u8868\uff08\u591a\u8868\u65f6\u7528\u9017\u53f7\u5206\u9694\uff0c\u4f8b\u5982\uff1aorders,customers\uff09\u3002\n  -\u8fd4\u56de\u7684sql\u8bed\u53e5\u7b26\u5408postgre\u6570\u636e\u5e93\u7684sql\u89c4\u8303\uff0c\u4e0d\u80fd\u6709\u8bed\u6cd5\u9519\u8bef\u3002\n  -\u6240\u6709\u5b57\u6bb5\u5fc5\u987b\u663e\u5f0f\u58f0\u660e\u522b\u540d\uff0c\u5f3a\u5236\u4f7f\u7528AS\u5173\u952e\u5b57\uff08\u4f8b\u5982\uff1atotal_amount AS \u9500\u552e\u989d_\u603b\u548c,\u5e74\u4efd\u548c\u653f\u533a\u5b57\u6bb5\u5fc5\u987b\u653e\u5728\u6700\u524d\u9762\u663e\u793a\u3002\n  -\u65e0\u8bba\u662f\u5426\u5b58\u5728\u7a7a\u95f4\u6761\u4ef6\uff0cWHERE\u5b50\u53e5\u4e2d\u5fc5\u987b\u5305\u542b{{spatial}}\n  -\u4e25\u7981\u51fa\u73b0NOT {{spatial}}\u7684\u8868\u8fbe\u5f0f\uff0c\u7edf\u4e00\u66ff\u6362\u4e3a{{spatial}}\u7684\u8868\u8fbe\u5f0f\u3002\n  -\u7edf\u8ba1\u5b57\u6bb5\u547d\u540d\u89c4\u8303\uff1a\n         .\u683c\u5f0f\uff1a**_\u7edf\u8ba1\u65b9\u6cd5\uff08\u4f8b\u5982\uff1a\u8015\u5730\u9762\u79ef_\u603b\u548c\u3001\u8015\u5730_\u4e2a\u6570\uff09\uff0c\u5982\u679c\u7edf\u8ba1\u65b9\u6cd5\u662f\u4e2a\u6570\u65f6\u3002\uff08\u5907\u6ce8\uff1a\u4ec5\u5728\u7edf\u8ba1\u7684\u573a\u666f\u4e2d\u9700\u8981\u8fd9\u4e48\u5904\u7406\uff09\u3002\n         .\u7edf\u8ba1\u65b9\u6cd5\u9650\u5b9a\uff1a\u603b\u548c\u3001\u6700\u5927\u503c\u3001\u6700\u5c0f\u503c\u3001\u5e73\u5747\u503c\u3001\u4e2a\u6570\u3002\n         .\u4f4d\u7f6e\uff1a\u5728SELECT\u8bed\u53e5\u4e2d\u5206\u7ec4\u5b57\u6bb5\uff08\u5982\u5e74\u4efd\u3001\u653f\u533a\uff09\u5fc5\u987b\u5728\u524d\uff0c\u7edf\u8ba1\u5b57\u6bb5\u5fc5\u987b\u5728\u540e\uff0c\u5982\u5e74\u4efd\u3001\u653f\u533a\u5b57\u6bb5\u5728\u524d\uff0c\u7edf\u8ba1\u9762\u79ef\u3001\u4e2a\u6570\u5b57\u6bb5\u5728\u540e\u3002\n  -\u7edf\u8ba1\u7ed3\u679c\u7cbe\u5ea6\uff1a\n         . \u539f\u59cb\u6570\u636e\u5355\u4f4d\u4e3a\u5e73\u65b9\u7c73\uff08m\u00b2\uff09\uff0c\u7edf\u8ba1\u7ed3\u679c\u9ed8\u8ba4\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002\n         . \u4f7f\u7528 `ROUND(CAST(value AS NUMERIC), 2)` \u8fdb\u884c\u56db\u820d\u4e94\u5165\u3002\n         . \u7981\u6b62\u5bf9 `DOUBLE PRECISION` \u7c7b\u578b\u76f4\u63a5\u4f7f\u7528 `ROUND`\uff0c\u5fc5\u987b\u5148\u901a\u8fc7 `CAST` \u8f6c\u6362\u4e3a `NUMERIC`\u3002";
    private static final String CHILDQUERY_PROMPT = "\u5b50\u67e5\u8be2\u5904\u7406\uff1a\u82e5\u5b58\u5728\u591a\u4e2a\u72ec\u7acb\u5b50\u67e5\u8be2\uff0c\u7981\u6b62\u4f7f\u7528UNION\u5408\u5e76\u7ed3\u679c\uff1b\u6bcf\u4e2a\u5b50\u67e5\u8be2\u5fc5\u987b\u751f\u6210\u72ec\u7acb\u7684SQL\u8bed\u53e5\u3002";
    private static final String XZQ_PROMPT = "\u884c\u653f\u533a\u5904\u7406\uff1a\n  .\u653f\u533a\u4ee3\u7801\u5b57\u6bb5\u5b58\u50a8\u7684\u90fd\u662f\u53bf\u7ea7\u653f\u533a\u4ee3\u7801,\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u5b58\u50a8\u7684\u90fd\u662f\u53bf\u7ea7\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u3002\n .\u5728WHERE\u5b50\u53e5\u4e2d\uff0c\u5fc5\u987b\u901a\u8fc7\u884c\u653f\u533a\u4ee3\u7801\u5b57\u6bb5\u8fdb\u884c\u8fc7\u6ee4\u3002\n .\u82e5\u5b57\u6bb5\u4e3a\u6570\u503c\u578b\uff0c\u9700\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u540e\u5339\u914d\uff1a`xzqdm::TEXT LIKE '64%'`\u3002\n .\u5728SELECT\u5b50\u53e5\u4e2d\uff0c\u82e5\u9700\u5c55\u793a\u884c\u653f\u533a\u4fe1\u606f\uff0c\u5fc5\u987b\u4f7f\u7528\u884c\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u5e76\u8d4b\u4e88\u9002\u5f53\u522b\u540d\u3002\n .\u67e5\u8be2\u5e02\u7ea7\u6570\u636e\uff08\u5982\u94f6\u5ddd\u5e02\uff09\u4f7f\u7528\u524d\u7f00\u5339\u914d\uff1a`LIKE '6401%'`\u3002\n .\u67e5\u8be2\u7701\u7ea7\u6570\u636e\uff08\u5982\u5b81\u590f\uff09\u4f7f\u7528\uff1a`LIKE '64%'`\u3002\n\uff08\u6ce8\uff1a\u56e0\u884c\u653f\u533a\u4ee3\u7801\u5b58\u50a8\u7684\u662f\u53bf\u7ea7\u7f16\u7801\uff0c\u6545\u901a\u8fc7\u524d\u7f00\u5339\u914d\u5b9e\u73b0\u4e0a\u7ea7\u533a\u57df\u805a\u5408\uff09\u3002\n .\u82e5\u95ee\u9898\u4e2d\u6709\u660e\u786e\u7684\u653f\u533a\u4fe1\u606f\u65f6\uff0c\u9700\u5728SELECT\u5b50\u53e5\u4e2d\u5c55\u793a\u653f\u533a\u4fe1\u606f\u3002\n .\u5173\u952e\u7981\u4ee4\uff1a\u82e5\u7edf\u8ba1\u8303\u56f4\u5bf9\u5e94\u7684\u884c\u653f\u533a\u7ea7\u522b\u4e0e\u5206\u7ec4\u5c42\u7ea7\u4e00\u81f4\uff0c\u6216\u95ee\u9898\u4e2d\u672a\u660e\u786e\u8981\u6c42\u6309\u884c\u653f\u533a\u5206\u7ec4\u7edf\u8ba1\u65f6\uff0c\u4e25\u7981\u6dfb\u52a0\u884c\u653f\u533a\u5206\u7ec4\uff08\u4f8b\u5982\uff1a\u7edf\u8ba1\u94f6\u5ddd\u5e02\u8015\u5730\u603b\u9762\u79ef\u5e76\u6309\u5e02\u6c47\u603b\u3001\u7edf\u8ba1\u94f6\u5ddd\u5e022019\u5e74\u8015\u5730\u9762\u79ef\u7b49\u573a\u666f\uff09\uff1b\u9700\u5c55\u793a\u56fa\u5b9a\u884c\u653f\u533a\u65f6\uff0c\u4f7f\u7528\u7c7b\u4f3cSELECT '\u94f6\u5ddd\u5e02' AS \u884c\u653f\u533a\u7684\u8bed\u53e5\u3002";
    private static final String DLBM_PROMPT = "\u4e0d\u80fd\u76f4\u63a5\u5c06DLMC(\u5730\u7c7b\u540d\u79f0)\u4f5c\u4e3a\u8fc7\u6ee4\u5b57\u6bb5\uff0c\u9700\u5c06\u5730\u7c7b\u540d\u79f0\u8f6c\u5316\u6210\u5bf9\u5e94\u7684\u5730\u7c7b\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\u8fc7\u6ee4,DLBM\u5b57\u6bb5\u4e2d\u5b58\u50a8\u7684\u90fd\u662f\u4e8c\u7ea7\u7c7b\u7f16\u7801";
    private static final String SPATIAL_PROMPT = "\u7a7a\u95f4\u8fc7\u6ee4\u5904\u7406\uff1a  \n  .\u5f53\u6d89\u53caST_Buffer\u3001ST_Contains\u3001ST_Intersects\u3001NOT ST_Buffer\u3001NOT ST_Contains\u3001NOT ST_Intersects\u7b49\u7a7a\u95f4\u51fd\u6570\u65f6\uff0c\u7edf\u4e00\u66ff\u6362\u4e3a\u5360\u4f4d\u7b26{{spatial}}\u3002\n  .\u5f53\u4e0d\u5b58\u5728\u7a7a\u95f4\u8fc7\u6ee4\u65f6\uff0cWHERE\u5b50\u53e5\u4e2d\u4e5f\u5fc5\u987b\u5305\u542b{{spatial}}\u3002\n  .\u5173\u952e\u7981\u4ee4:\u5728{{spatial}}\u5360\u4f4d\u7b26\u524d\u4e0d\u80fd\u6dfb\u52a0NOT\u8fd0\u7b97\u7b26\u6216\u5d4c\u5957\u5176\u4ed6\u51fd\u6570\u6216\u6761\u4ef6\u8868\u8fbe\u5f0f\u3002\n  .\u6b63\u786e\u7528\u6cd5\u7528\u4f8b\uff1aWHERE {{spatial}}\u3001 AND {{spatial}}\u3001 JOIN ... ON {{spatial}}\u3002\n  .\u9519\u8bef\u7528\u6cd5\u7528\u4f8b\uff1aWHERE NOT {{spatial}}\u3001 AND NOT {{spatial}}\u3001WHERE ST_Buffer({{spatial}}, 100)\u3002";
    private static final String YEAR_PROMPT = "\u5e74\u4efd\u5904\u7406:  \n  .\u5f53\u8868\u540d\u5305\u542b\u5e74\u4efd\u6807\u8bc6\uff08\u5982sales_2023\uff09\u65f6\uff0c\u6216\u8868\u7684\u6570\u636e\u5e74\u4efd\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u7981\u6b62\u4f7f\u7528\u5e74\u4efd\u5b57\u6bb5\uff08\u5982f_year\uff09\u8fdb\u884c\u8fc7\u6ee4\u6216\u5206\u7ec4\u64cd\u4f5c,\u9700\u5c55\u793a\u56fa\u5b9a\u5e74\u4efd\u65f6\uff0c\u4f7f\u7528\u7c7b\u4f3cSELECT '2010' AS \u5e74\u4efd\u7684\u8bed\u53e5\u3002\n  .\u82e5\u95ee\u9898\u672a\u8981\u6c42\u6309\u5e74\u4efd\u8fdb\u884c\u5206\u7ec4\u7edf\u8ba1\uff0c\u4e25\u7981\u6dfb\u52a0\u5e74\u4efd\u5206\u7ec4\u3002";
    private static final Template DATABASE_SCHEMA_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u4e25\u683c\u57fa\u4e8e\u4ee5\u4e0bPostgreSQL\u8868\u7ed3\u6784\uff1a  ${schema}");
    private static final Template RETURN_TEMPLATE_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u8f93\u51fa\u683c\u5f0f \u5fc5\u987b\u4e25\u683c\u4ee5JSON\u6570\u7ec4\u683c\u5f0f\u8fd4\u56de\u7ed3\u679c\uff0c\u7ed3\u6784\u5982\u4e0b\uff1a ${template}");
    private static final Template SCHEMA_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u4f5c\u4e3aPostgreSQL\u6570\u636e\u5e93\u5b89\u5168\u4e13\u5bb6\uff0c\u60a8\u5fc5\u987b\u5c06\u7528\u6237\u95ee\u9898\u4e25\u683c\u8f6c\u6362\u4e3a\u53ea\u8bfbSQL\u67e5\u8be2\u8bed\u53e5\uff08\u4ec5\u9650SELECT\u64cd\u4f5c\uff0c\u7981\u6b62\u4efb\u4f55\u5199\u5165\u6216\u4fee\u6539\u64cd\u4f5c\uff09\u3002\u8f6c\u6362\u8fc7\u7a0b\u9700\u5b9e\u65bd\u4e3b\u52a8\u9632\u5fa1\u63aa\u65bd\u4ee5\u675c\u7eddSQL\u6ce8\u5165\u98ce\u9669\uff0c\u5e76\u4e25\u683c\u9075\u5faa\u4ee5\u4e0b\u89c4\u8303\uff1a\n\n1\u3001\u8fd4\u56de\u5185\u5bb9\u8981\u6c42\n\n   -\u8f93\u51fa\u5b8c\u6574\u7684SQL\u8bed\u53e5\u53ca\u88ab\u67e5\u8be2\u7684\u8868\u540d\u5217\u8868\uff08\u591a\u8868\u65f6\u7528\u9017\u53f7\u5206\u9694\uff0c\u4f8b\u5982\uff1aorders,customers\uff09\u3002\n   -\u8fd4\u56de\u7684sql\u8bed\u53e5\u7b26\u5408postgre\u6570\u636e\u5e93\u7684sql\u89c4\u8303\uff0c\u4e0d\u80fd\u6709\u8bed\u6cd5\u9519\u8bef\u3002\n   -\u6240\u6709\u5b57\u6bb5\u5fc5\u987b\u663e\u5f0f\u58f0\u660e\u522b\u540d\uff0c\u5f3a\u5236\u4f7f\u7528AS\u5173\u952e\u5b57\uff08\u4f8b\u5982\uff1atotal_amount AS \u9500\u552e\u989d_\u603b\u548c,\u5e74\u4efd\u548c\u653f\u533a\u5b57\u6bb5\u5fc5\u987b\u653e\u5728\u6700\u524d\u9762\u663e\u793a\u3002\n   -\u65e0\u8bba\u662f\u5426\u5b58\u5728\u7a7a\u95f4\u6761\u4ef6\uff0cWHERE\u5b50\u53e5\u4e2d\u5fc5\u987b\u5305\u542b{{spatial}}   -\u4e25\u7981\u51fa\u73b0NOT {{spatial}}\u7684\u8868\u8fbe\u5f0f\uff0c\u7edf\u4e00\u66ff\u6362\u4e3a{{spatial}}\u7684\u8868\u8fbe\u5f0f\u3002\n   -\u7edf\u8ba1\u5b57\u6bb5\u547d\u540d\u89c4\u8303\uff1a\n      .\u683c\u5f0f\uff1a**_\u7edf\u8ba1\u65b9\u6cd5\uff08\u4f8b\u5982\uff1a\u8015\u5730\u9762\u79ef_\u603b\u548c\u3001\u8015\u5730_\u4e2a\u6570\uff09\uff0c\u5982\u679c\u7edf\u8ba1\u65b9\u6cd5\u662f\u4e2a\u6570\u65f6\u3002\uff08\u5907\u6ce8\uff1a\u4ec5\u5728\u7edf\u8ba1\u7684\u573a\u666f\u4e2d\u9700\u8981\u8fd9\u4e48\u5904\u7406\uff09\u3002\n      .\u7edf\u8ba1\u65b9\u6cd5\u9650\u5b9a\uff1a\u603b\u548c\u3001\u6700\u5927\u503c\u3001\u6700\u5c0f\u503c\u3001\u5e73\u5747\u503c\u3001\u4e2a\u6570\u3002\n      .\u4f4d\u7f6e\uff1a\u5728SELECT\u8bed\u53e5\u4e2d\u5206\u7ec4\u5b57\u6bb5\uff08\u5982\u5e74\u4efd\u3001\u653f\u533a\uff09\u5fc5\u987b\u5728\u524d\uff0c\u7edf\u8ba1\u5b57\u6bb5\u5fc5\u987b\u5728\u540e\uff0c\u5982\u5e74\u4efd\u3001\u653f\u533a\u5b57\u6bb5\u5728\u524d\uff0c\u7edf\u8ba1\u9762\u79ef\u3001\u4e2a\u6570\u5b57\u6bb5\u5728\u540e\u3002\n   -\u7edf\u8ba1\u7ed3\u679c\u7cbe\u5ea6\uff1a\n       . \u539f\u59cb\u6570\u636e\u5355\u4f4d\u4e3a\u5e73\u65b9\u7c73\uff08m\u00b2\uff09\uff0c\u7edf\u8ba1\u7ed3\u679c\u9ed8\u8ba4\u4fdd\u75592\u4f4d\u5c0f\u6570\u3002\n       . \u4f7f\u7528 `ROUND(CAST(value AS NUMERIC), 2)` \u8fdb\u884c\u56db\u820d\u4e94\u5165\u3002\n       . \u7981\u6b62\u5bf9 `DOUBLE PRECISION` \u7c7b\u578b\u76f4\u63a5\u4f7f\u7528 `ROUND`\uff0c\u5fc5\u987b\u5148\u901a\u8fc7 `CAST` \u8f6c\u6362\u4e3a `NUMERIC`\u3002\n\n2\u3001\u7279\u6b8a\u573a\u666f\u5904\u7406\n\n   -\u5b50\u67e5\u8be2\uff1a\u82e5\u5b58\u5728\u591a\u4e2a\u72ec\u7acb\u5b50\u67e5\u8be2\uff0c\u7981\u6b62\u4f7f\u7528UNION\u5408\u5e76\u7ed3\u679c\uff1b\u6bcf\u4e2a\u5b50\u67e5\u8be2\u5fc5\u987b\u751f\u6210\u72ec\u7acb\u7684SQL\u8bed\u53e5\n   -\u7a7a\u95f4\u8fc7\u6ee4\uff1a    \n      .\u5f53\u6d89\u53caST_Buffer\u3001ST_Contains\u3001ST_Intersects\u3001NOT ST_Buffer\u3001NOT ST_Contains\u3001NOT ST_Intersects\u7b49\u7a7a\u95f4\u51fd\u6570\u65f6\uff0c\u7edf\u4e00\u66ff\u6362\u4e3a\u5360\u4f4d\u7b26{{spatial}}\u3002\n      .\u5f53\u4e0d\u5b58\u5728\u7a7a\u95f4\u8fc7\u6ee4\u65f6\uff0cWHERE\u5b50\u53e5\u4e2d\u4e5f\u5fc5\u987b\u5305\u542b{{spatial}}      .\u5173\u952e\u7981\u4ee4:\u5728{{spatial}}\u5360\u4f4d\u7b26\u524d\u4e0d\u80fd\u6dfb\u52a0NOT\u8fd0\u7b97\u7b26\u6216\u5d4c\u5957\u5176\u4ed6\u51fd\u6570\u6216\u6761\u4ef6\u8868\u8fbe\u5f0f\u3002\n                \u6b63\u786e\u7528\u6cd5\u7528\u4f8b\uff1aWHERE {{spatial}}\u3001 AND {{spatial}}\u3001 JOIN ... ON {{spatial}}\u3002\n                \u9519\u8bef\u7528\u6cd5\u7528\u4f8b\uff1aWHERE NOT {{spatial}}\u3001 AND NOT {{spatial}}\u3001WHERE ST_Buffer({{spatial}}, 100) \n   -\u884c\u653f\u533a\u5904\u7406\uff1a\n      .\u653f\u533a\u4ee3\u7801\u5b57\u6bb5\u5b58\u50a8\u7684\u90fd\u662f\u53bf\u7ea7\u653f\u533a\u4ee3\u7801,\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u5b58\u50a8\u7684\u90fd\u662f\u53bf\u7ea7\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u3002\n      .\u5728WHERE\u5b50\u53e5\u4e2d\uff0c\u5fc5\u987b\u901a\u8fc7\u884c\u653f\u533a\u4ee3\u7801\u5b57\u6bb5\u8fdb\u884c\u8fc7\u6ee4\u3002\n      .\u82e5\u5b57\u6bb5\u4e3a\u6570\u503c\u578b\uff0c\u9700\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u540e\u5339\u914d\uff1a`xzqdm::TEXT LIKE '64%'`\u3002\n      .\u5728SELECT\u5b50\u53e5\u4e2d\uff0c\u82e5\u9700\u5c55\u793a\u884c\u653f\u533a\u4fe1\u606f\uff0c\u5fc5\u987b\u4f7f\u7528\u884c\u653f\u533a\u540d\u79f0\u5b57\u6bb5\u5e76\u8d4b\u4e88\u9002\u5f53\u522b\u540d\u3002\n      .\u67e5\u8be2\u5e02\u7ea7\u6570\u636e\uff08\u5982\u94f6\u5ddd\u5e02\uff09\u4f7f\u7528\u524d\u7f00\u5339\u914d\uff1a`LIKE '6401%'`\u3002\n      .\u67e5\u8be2\u7701\u7ea7\u6570\u636e\uff08\u5982\u5b81\u590f\uff09\u4f7f\u7528\uff1a`LIKE '64%'`\u3002\n      \uff08\u6ce8\uff1a\u56e0\u884c\u653f\u533a\u4ee3\u7801\u5b58\u50a8\u7684\u662f\u53bf\u7ea7\u7f16\u7801\uff0c\u6545\u901a\u8fc7\u524d\u7f00\u5339\u914d\u5b9e\u73b0\u4e0a\u7ea7\u533a\u57df\u805a\u5408\uff09\u3002\n      .\u82e5\u95ee\u9898\u4e2d\u6709\u660e\u786e\u7684\u653f\u533a\u4fe1\u606f\u65f6\uff0c\u9700\u5728SELECT\u5b50\u53e5\u4e2d\u5c55\u793a\u653f\u533a\u4fe1\u606f\u3002\n      .\u5173\u952e\u7981\u4ee4\uff1a\u82e5\u7edf\u8ba1\u8303\u56f4\u5bf9\u5e94\u7684\u884c\u653f\u533a\u7ea7\u522b\u4e0e\u5206\u7ec4\u5c42\u7ea7\u4e00\u81f4\uff0c\u6216\u95ee\u9898\u4e2d\u672a\u660e\u786e\u8981\u6c42\u6309\u884c\u653f\u533a\u5206\u7ec4\u7edf\u8ba1\u65f6\uff0c\u4e25\u7981\u6dfb\u52a0\u884c\u653f\u533a\u5206\u7ec4\uff08\u4f8b\u5982\uff1a\u7edf\u8ba1\u94f6\u5ddd\u5e02\u8015\u5730\u603b\u9762\u79ef\u5e76\u6309\u5e02\u6c47\u603b\u3001\u7edf\u8ba1\u94f6\u5ddd\u5e022019\u5e74\u8015\u5730\u9762\u79ef\u7b49\u573a\u666f\uff09\uff1b\u9700\u5c55\u793a\u56fa\u5b9a\u884c\u653f\u533a\u65f6\uff0c\u4f7f\u7528\u7c7b\u4f3cSELECT '\u94f6\u5ddd\u5e02' AS \u884c\u653f\u533a\u7684\u8bed\u53e5\u3002\n   -\u5e74\u4efd\u5904\u7406\uff1a\n      .\u5f53\u8868\u540d\u5305\u542b\u5e74\u4efd\u6807\u8bc6\uff08\u5982sales_2023\uff09\u65f6\uff0c\u6216\u8868\u7684\u6570\u636e\u5e74\u4efd\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u7981\u6b62\u4f7f\u7528\u5e74\u4efd\u5b57\u6bb5\uff08\u5982f_year\uff09\u8fdb\u884c\u8fc7\u6ee4\u6216\u5206\u7ec4\u64cd\u4f5c,\u9700\u5c55\u793a\u56fa\u5b9a\u5e74\u4efd\u65f6\uff0c\u4f7f\u7528\u7c7b\u4f3cSELECT '2010' AS \u5e74\u4efd\u7684\u8bed\u53e5\u3002\n      .\u82e5\u95ee\u9898\u672a\u8981\u6c42\u6309\u5e74\u4efd\u8fdb\u884c\u5206\u7ec4\u7edf\u8ba1\uff0c\u4e25\u7981\u6dfb\u52a0\u5e74\u4efd\u5206\u7ec4\u3002\n      .\u82e5\u95ee\u9898\u4e2d\u6709\u660e\u786e\u7684\u5e74\u4efd\u65f6\uff0c\u9700\u5728SELECT\u5b50\u53e5\u4e2d\u5c55\u793a\u5e74\u4efd\u4fe1\u606f\u3002\n3\u3001\u8f93\u51fa\u683c\u5f0f \u5fc5\u987b\u4e25\u683c\u4ee5JSON\u6570\u7ec4\u683c\u5f0f\u8fd4\u56de\u7ed3\u679c\uff0c\u7ed3\u6784\u5982\u4e0b\uff1a ${template}\n\n4\u3001\u8868\u7ed3\u6784\u5b9a\u4e49\uff1a \u4e25\u683c\u57fa\u4e8e\u4ee5\u4e0bPostgreSQL\u8868\u7ed3\u6784\uff1a  ${schema}\n\n5\u3001\u4e1a\u52a1\u5907\u6ce8\uff1a\u9700\u878d\u5408\u7684\u4e1a\u52a1\u903b\u8f91\u7ea6\u675f\uff1a ${comment}\n\n6\u3001\u7528\u6237\u95ee\u9898\uff1a \u5f85\u8f6c\u6362\u7684\u81ea\u7136\u8bed\u8a00\u8f93\u5165\uff1a  ${question}");

    private AiToolResult getSql(AiSqlToolParam param) {
        if (this.aiToolContext.containsKey(KEY_MESSAGE_SQL)) {
            return (AiToolResult)this.aiToolContext.get(KEY_MESSAGE_SQL, AiToolResult.class);
        }
        List<AiCatalogDataNodeDTO> relateTables = AICatalogNodeUtil.getCatalogNodesFromCache(this.aiToolContext);
        String template = this.getJsonTempalte();
        String schema = this.getSchema(relateTables);
        AiGeometryToolCallResult geometryResult = AIGeometryToolUtil.getGeometry(this.aiToolContext.getUserInput(), this.aiToolContext, this.aiMessageConsumer);
        String spatialCondition = "1=1";
        if (geometryResult != null && !geometryResult.getIsXzq().booleanValue()) {
            spatialCondition = geometryResult.getRelationType() == SpatialRelationType.Intersects ? String.format("ST_Intersects(shape,ST_GeomFromText('%s',4490))", geometryResult.getShape()) : String.format("ST_Disjoint(shape,ST_GeomFromText('%s',4490))", geometryResult.getShape());
        }
        AiSystemMessage roleMessage = new AiSystemMessage(ROLE_PROMPT);
        AiSystemMessage returnMessage = new AiSystemMessage(RETURN_PROMPT);
        AiSystemMessage childQureyMessage = new AiSystemMessage(CHILDQUERY_PROMPT);
        AiSystemMessage xzqMessage = new AiSystemMessage(XZQ_PROMPT);
        AiSystemMessage spatialMessage = new AiSystemMessage(SPATIAL_PROMPT);
        AiSystemMessage yearMessage = new AiSystemMessage(YEAR_PROMPT);
        AiSystemMessage tableMessage = new AiSystemMessage(DATABASE_SCHEMA_PROMPT.render((Map)Dict.create().set("schema", (Object)schema)));
        AiSystemMessage returnTemplateMessage = new AiSystemMessage(RETURN_TEMPLATE_PROMPT.render((Map)Dict.create().set("template", (Object)template)));
        AiSystemMessage comment2009_2018 = new AiSystemMessage(this.getComment2009_2018());
        AiSystemMessage comment2019Message = new AiSystemMessage(this.getComment2019());
        AiUserMessage userMessage = new AiUserMessage(param.getMessage());
        ArrayList<Object> aiMessages = new ArrayList<Object>();
        aiMessages.add(roleMessage);
        aiMessages.add(returnMessage);
        aiMessages.add(childQureyMessage);
        aiMessages.add(xzqMessage);
        aiMessages.add(spatialMessage);
        aiMessages.add(yearMessage);
        aiMessages.add(tableMessage);
        aiMessages.add(returnTemplateMessage);
        aiMessages.add(comment2009_2018);
        aiMessages.add(comment2019Message);
        aiMessages.add(userMessage);
        long start = System.currentTimeMillis();
        AiChatClient chatClient = this.aiToolContext.getChatClient();
        AiChatResult chatResult = chatClient.chat(aiMessages, null, this.aiToolContext);
        System.out.println("\u81ea\u7136\u8f6csql\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        String sqlQuery = AIReturnContentUtil.removeThink(chatResult.getContent());
        sqlQuery = AIReturnContentUtil.removeJson(sqlQuery);
        List returnResults = JSONUtil.toList((String)sqlQuery, AiReturnResult.class);
        ArrayList<AiSqlResultDTO> result = new ArrayList<AiSqlResultDTO>();
        for (AiReturnResult aiReturnResult : returnResults) {
            AiSqlResultDTO aiSqlResultDTO = new AiSqlResultDTO();
            aiSqlResultDTO.setIsStat(aiReturnResult.isStat);
            aiSqlResultDTO.setLayers(relateTables.stream().filter(f -> aiReturnResult.getTableIds().contains(f.getNodeId())).collect(Collectors.toList()));
            aiSqlResultDTO.setSql(aiReturnResult.getSql().replace("{{spatial}}", spatialCondition));
            result.add(aiSqlResultDTO);
        }
        AiSqlToolCallResult aiSqlToolCallResult = new AiSqlToolCallResult();
        aiSqlToolCallResult.setSqlResults(result);
        AiToolResult aiToolResult = new AiToolResult(String.format("\u89e3\u6790\u5230\u7684sql\u8bed\u53e5\u4e3a\uff1a%s", sqlQuery), (Object)aiSqlToolCallResult);
        this.messageInvoke(aiToolResult);
        aiToolResult.setReturn(Boolean.valueOf(false));
        this.aiToolContext.put(KEY_MESSAGE_SQL, (Object)aiToolResult);
        return aiToolResult;
    }

    protected AiToolResult call(AiSqlToolParam param) {
        try {
            return this.getSql(param);
        }
        catch (Exception exception) {
            throw new RuntimeException("\u83b7\u53d6sql\u8bed\u53e5\u5931\u8d25", exception);
        }
    }

    private String getComment() {
        return "1\u3001 \u6570\u636e\u5e74\u4efd\u4e3a2009-2018\u5e74\u95f4\u7684\u56fd\u571f\u8c03\u67e5\u6570\u636e\uff0cDLBM(\u5730\u7c7b\u7f16\u7801)\u3001DLMC(\u5730\u7c7b\u540d\u79f0)\u5b57\u6bb5\u7684\u53d6\u503c\u53c2\u7167\u56fd\u571f\u4e8c\u8c03\u571f\u5730\u5206\u7c7b\u6807\u51c6,\u4e0d\u80fd\u76f4\u63a5\u5c06DLMC(\u5730\u7c7b\u540d\u79f0)\u4f5c\u4e3a\u8fc7\u6ee4\u5b57\u6bb5\uff0c\u9700\u5c06\u5730\u7c7b\u540d\u79f0\u8f6c\u5316\u6210\u5bf9\u5e94\u7684\u5730\u7c7b\u7f16\u7801\u8fdb\u884c\u67e5\u8be2,\u5206\u7c7b\u6807\u51c6\u5982\u4e0b\n01 \u8015\u5730\n011\u6c34\u7530|\u6c34\u6e90\u704c\u6e89,\u79cd\u6c34\u7a3b\u7b49\n012\u6c34\u6d47\u5730|\u704c\u6e89\u65f1\u4f5c,\u79cd\u5c0f\u9ea6\u852c\u83dc\n013\u65f1\u5730|\u65e0\u704c\u6e89,\u9760\u964d\u6c34\n\n02 \u56ed\u5730\n021\u679c\u56ed|\u82f9\u679c\u67d1\u6a58\u7b49\n022\u8336\u56ed|\u8336\u6811\n023\u5176\u4ed6\u56ed\u5730|\u6851\u6811\u6a61\u80f6\u7b49\n\n03 \u6797\u5730\n031\u6709\u6797\u5730|\u6811\u6728\u90c1\u95ed\u22650.2\n032\u704c\u6728\u6797|\u704c\u6728\u90c1\u95ed\u22650.4\n033\u5176\u4ed6\u6797|\u758f\u6797/\u82d7\u5703\u7b49\n\n04 \u8349\u5730\n041\u5929\u7136\u7267\u8349|\u5929\u7136\u8349\u672c\u755c\u7267\n042\u4eba\u5de5\u7267\u8349|\u4eba\u5de5\u79cd\u690d\n043\u5176\u4ed6\u8349\u5730|\u672a\u5229\u7528\u7b49\n\n05 \u5546\u670d\u7528\u5730\n051\u6279\u53d1\u96f6\u552e|\u5546\u573a\u5546\u94fa\n052\u4f4f\u5bbf\u9910\u996e|\u5bbe\u9986\u996d\u5e97\n053\u5546\u52a1\u91d1\u878d|\u5199\u5b57\u697c\u94f6\u884c\n054\u5176\u4ed6\u5546\u670d|\u5a31\u4e50\u52a0\u6cb9\u7ad9\n\n06 \u5de5\u77ff\u4ed3\u50a8\n061\u5de5\u4e1a|\u751f\u4ea7\u8bbe\u65bd\n062\u91c7\u77ff|\u91c7\u77f3\u91c7\u77ff\n063\u4ed3\u50a8|\u7269\u6d41\u5806\u573a\n\n07 \u4f4f\u5b85\n071\u57ce\u9547\u4f4f\u5b85|\u57ce\u5e02\u4f4f\u5b85\n072\u519c\u6751\u5b85\u57fa|\u6751\u6c11\u4f4f\u5b85\n\n08 \u516c\u5171\u7ba1\u7406\n081\u673a\u5173\u56e2\u4f53|\u653f\u5e9c\u5355\u4f4d\n082\u79d1\u6559\u6587\u536b|\u5b66\u6821\u533b\u9662\n083\u516c\u56ed\u7eff\u5730|\u516c\u5171\u7eff\u5730\n\n09 \u7279\u6b8a\u7528\u5730\n091\u519b\u4e8b|\u57fa\u5730\u9776\u573a\n092\u5b97\u6559|\u5bfa\u5e99\u6559\u5802\n093\u6ba1\u846c|\u5893\u5730\u9675\u56ed\n\n10 \u4ea4\u901a\n101\u94c1\u8def|\u7ebf\u8def\u573a\u7ad9\n102\u516c\u8def|\u9ad8\u901f\u56fd\u9053\n103\u673a\u573a|\u822a\u7a7a\u8bbe\u65bd\n104\u6e2f\u53e3|\u7801\u5934\n105\u7ba1\u9053|\u6cb9\u6c14\u7ba1\u9053\n\n11 \u6c34\u57df\n111\u6cb3\u6d41|\u5929\u7136\u6cb3\u9053\n112\u6e56\u6cca|\u5929\u7136\u6e56\n113\u6c34\u5e93|\u4eba\u5de5\u6c34\u5e93\n114\u5751\u5858|\u517b\u6b96\u5858\n115\u6cbf\u6d77\u6ee9\u6d82|\u6f6e\u95f4\u5e26\n116\u5185\u9646\u6ee9\u6d82|\u6cb3\u6e56\u6ee9\n117\u6c9f\u6e20|\u704c\u6e89\u6e20\n118\u6c34\u5de5|\u5824\u575d\u95f8\u7ad9\n\n12 \u5176\u4ed6\n121\u7a7a\u95f2|\u672a\u5229\u7528\n122\u8bbe\u65bd\u519c\u7528|\u6e29\u5ba4\u517b\u6b96\n123\u7530\u574e|\u8015\u5730\u7530\u57c2\n124\u76d0\u78b1|\u76d0\u78b1\u5730\n125\u6cbc\u6cfd|\u6e7f\u5730\n126\u6c99\u5730|\u6c99\u8986\u76d6\n127\u88f8\u5730|\u65e0\u690d\u88ab2\u3001 \u6570\u636e\u5e74\u4efd\u4e3a2019\u5e74\u4ee5\u53ca\u4e4b\u540e\u7684\u56fd\u571f\u8c03\u67e5\u6570\u636e,DLBM(\u5730\u7c7b\u7f16\u7801)\u3001DLMC(\u5730\u7c7b\u540d\u79f0)\u5b57\u6bb5\u7684\u53d6\u503c\u53c2\u7167\u56fd\u571f\u4e09\u8c03\u571f\u5730\u5206\u7c7b\u6807\u51c6,\u4e0d\u80fd\u76f4\u63a5\u5c06DLMC(\u5730\u7c7b\u540d\u79f0)\u4f5c\u4e3a\u8fc7\u6ee4\u5b57\u6bb5\uff0c\u9700\u5c06\u5730\u7c7b\u540d\u79f0\u8f6c\u5316\u6210\u5bf9\u5e94\u7684\u5730\u7c7b\u7f16\u7801\u8fdb\u884c\u67e5,\u5206\u7c7b\u6807\u51c6\u5982\u4e0b\uff1a\n01 \u8015\u5730\n0101\u6c34\u7530|\u6c34\u6e90\u704c\u6e89,\u79cd\u6c34\u7a3b\u7b49\n0102\u6c34\u6d47\u5730|\u704c\u6e89\u65f1\u4f5c,\u79cd\u5c0f\u9ea6\u852c\u83dc\n0103\u65f1\u5730|\u65e0\u704c\u6e89,\u9760\u964d\u6c34\n\n02 \u56ed\u5730\n0201\u679c\u56ed|\u82f9\u679c\u67d1\u6a58\u7b49\n0202\u8336\u56ed|\u8336\u6811\n0203\u6a61\u80f6\u56ed|\u6a61\u80f6\u6811\n0204\u5176\u4ed6\u56ed\u5730|\u5496\u5561\u7b49\n\n03 \u6797\u5730\n0301\u4e54\u6728\u6797|\u6811\u6728\u90c1\u95ed\u22650.2\n0302\u7af9\u6797|\u6bdb\u7af9\u7b49\n0303\u7ea2\u6811\u6797|\u6d77\u5cb8\u7ea2\u6811\n0304\u68ee\u6797\u6cbc\u6cfd|\u6797\u5730+\u6cbc\u6cfd\n0305\u704c\u6728\u6797|\u704c\u6728\u90c1\u95ed\u22650.4\n0306\u5176\u4ed6\u6797\u5730|\u758f\u6797/\u82d7\u5703\n\n04 \u8349\u5730\n0401\u5929\u7136\u7267\u8349|\u5929\u7136\u8349\u672c\u755c\u7267\n0402\u6cbc\u6cfd\u8349\u5730|\u6e7f\u5730\u8349\u5730\n0403\u4eba\u5de5\u7267\u8349|\u4eba\u5de5\u79cd\u690d\n0404\u5176\u4ed6\u8349\u5730|\u672a\u5229\u7528\u7b49\n\n05 \u5546\u4e1a\u670d\u52a1\u4e1a\n0501\u96f6\u552e\u5546\u4e1a|\u5546\u573a\u5546\u94fa\n0502\u6279\u53d1\u5e02\u573a|\u6279\u53d1\u4ea4\u6613\n0503\u9910\u996e|\u996d\u5e97\u9910\u5385\n0504\u65c5\u9986|\u5bbe\u9986\u9152\u5e97\n0505\u5546\u52a1\u91d1\u878d|\u5199\u5b57\u697c\u94f6\u884c\n0506\u5a31\u4e50|KTV\u5f71\u9662\n0507\u5176\u4ed6\u5546\u670d|\u52a0\u6cb9\u7ad9\u7b49\n\n06 \u5de5\u77ff\u4ed3\u50a8\n0601\u5de5\u4e1a|\u751f\u4ea7\u8bbe\u65bd\n0602\u91c7\u77ff|\u77ff\u533a\n0603\u76d0\u7530|\u6652\u76d0\u573a\n0604\u4ed3\u50a8|\u7269\u6d41\u4ed3\u5e93\n\n07 \u4f4f\u5b85\n0701\u57ce\u9547\u4f4f\u5b85|\u5546\u54c1\u623f\u7b49\n0702\u519c\u6751\u4f4f\u5b85|\u6751\u6c11\u81ea\u5efa\u623f\n\n08 \u516c\u5171\u7ba1\u7406\u670d\u52a1\n0801\u673a\u5173\u56e2\u4f53|\u653f\u5e9c\u5355\u4f4d\n0802\u6559\u80b2|\u5b66\u6821\n0803\u79d1\u7814|\u7814\u7a76\u6240\n0804\u533b\u7597|\u533b\u9662\n0805\u6587\u4f53|\u535a\u7269\u9986\u4f53\u80b2\u9986\n0806\u516c\u56ed\u7eff\u5730|\u516c\u5171\u7eff\u5730\n\n09 \u7279\u6b8a\u7528\u5730\n0901\u519b\u4e8b|\u57fa\u5730\u9776\u573a\n0902\u5b97\u6559|\u5bfa\u5e99\u6559\u5802\n0903\u6ba1\u846c|\u5893\u5730\u9675\u56ed\n0904\u98ce\u666f\u540d\u80dc|\u666f\u533a\n\n10 \u4ea4\u901a\u8fd0\u8f93\n1001\u94c1\u8def|\u7ebf\u8def\u573a\u7ad9\n1002\u8f68\u9053\u4ea4\u901a|\u5730\u94c1\u8f7b\u8f68\n1003\u516c\u8def|\u9ad8\u901f\u56fd\u9053\n1004\u57ce\u9547\u9053\u8def|\u5e02\u653f\u9053\u8def\n1005\u673a\u573a|\u822a\u7a7a\u8bbe\u65bd\n1006\u6e2f\u53e3\u7801\u5934|\u8d27\u8fd0\u5ba2\u8fd0\n1007\u7ba1\u9053\u8fd0\u8f93|\u6cb9\u6c14\u7ba1\u9053\n\n11 \u6c34\u57df\u6c34\u5229\n1101\u6cb3\u6d41|\u5929\u7136\u6cb3\u9053\n1102\u6e56\u6cca|\u5929\u7136\u6e56\n1103\u6c34\u5e93|\u4eba\u5de5\u6c34\u5e93\n1104\u5751\u5858|\u517b\u6b96\u5858\n1105\u6cbf\u6d77\u6ee9\u6d82|\u6f6e\u95f4\u5e26\n1106\u5185\u9646\u6ee9\u6d82|\u6cb3\u6e56\u6ee9\n1107\u6c9f\u6e20|\u704c\u6e89\u6e20\n1108\u6c34\u5de5\u5efa\u7b51|\u5824\u575d\u95f8\u7ad9\n\n12 \u5176\u4ed6\u571f\u5730\n1201\u7a7a\u95f2\u5730|\u672a\u5229\u7528\n1202\u8bbe\u65bd\u519c\u5730|\u6e29\u5ba4\u517b\u6b96\n1203\u7530\u574e|\u8015\u5730\u7530\u57c2\n1204\u76d0\u78b1\u5730|\u76d0\u78b1\u5316\n1205\u6cbc\u6cfd\u5730|\u6e7f\u5730\n1206\u6c99\u5730|\u6c99\u8986\u76d6\n1207\u88f8\u571f\u5730|\u65e0\u690d\u88ab";
    }

    private String getComment2019() {
        return "\u6570\u636e\u5e74\u4efd\u4e3a2019\u5e74\u4ee5\u53ca\u4e4b\u540e\u7684\u56fd\u571f\u8c03\u67e5\u6570\u636e\uff0c\u5730\u7c7b\u7f16\u7801\u5206\u7c7b\u6807\u51c6\u5982\u4e0b\uff1a\n01 \u8015\u5730\n0101\u6c34\u7530|\u6c34\u6e90\u704c\u6e89,\u79cd\u6c34\u7a3b\u7b49\n0102\u6c34\u6d47\u5730|\u704c\u6e89\u65f1\u4f5c,\u79cd\u5c0f\u9ea6\u852c\u83dc\n0103\u65f1\u5730|\u65e0\u704c\u6e89,\u9760\u964d\u6c34\n\n02 \u56ed\u5730\n0201\u679c\u56ed|\u82f9\u679c\u67d1\u6a58\u7b49\n0202\u8336\u56ed|\u8336\u6811\n0203\u6a61\u80f6\u56ed|\u6a61\u80f6\u6811\n0204\u5176\u4ed6\u56ed\u5730|\u5496\u5561\u7b49\n\n03 \u6797\u5730\n0301\u4e54\u6728\u6797|\u6811\u6728\u90c1\u95ed\u22650.2\n0302\u7af9\u6797|\u6bdb\u7af9\u7b49\n0303\u7ea2\u6811\u6797|\u6d77\u5cb8\u7ea2\u6811\n0304\u68ee\u6797\u6cbc\u6cfd|\u6797\u5730+\u6cbc\u6cfd\n0305\u704c\u6728\u6797|\u704c\u6728\u90c1\u95ed\u22650.4\n0306\u5176\u4ed6\u6797\u5730|\u758f\u6797/\u82d7\u5703\n\n04 \u8349\u5730\n0401\u5929\u7136\u7267\u8349|\u5929\u7136\u8349\u672c\u755c\u7267\n0402\u6cbc\u6cfd\u8349\u5730|\u6e7f\u5730\u8349\u5730\n0403\u4eba\u5de5\u7267\u8349|\u4eba\u5de5\u79cd\u690d\n0404\u5176\u4ed6\u8349\u5730|\u672a\u5229\u7528\u7b49\n\n05 \u5546\u4e1a\u670d\u52a1\u4e1a\n0501\u96f6\u552e\u5546\u4e1a|\u5546\u573a\u5546\u94fa\n0502\u6279\u53d1\u5e02\u573a|\u6279\u53d1\u4ea4\u6613\n0503\u9910\u996e|\u996d\u5e97\u9910\u5385\n0504\u65c5\u9986|\u5bbe\u9986\u9152\u5e97\n0505\u5546\u52a1\u91d1\u878d|\u5199\u5b57\u697c\u94f6\u884c\n0506\u5a31\u4e50|KTV\u5f71\u9662\n0507\u5176\u4ed6\u5546\u670d|\u52a0\u6cb9\u7ad9\u7b49\n\n06 \u5de5\u77ff\u4ed3\u50a8\n0601\u5de5\u4e1a|\u751f\u4ea7\u8bbe\u65bd\n0602\u91c7\u77ff|\u77ff\u533a\n0603\u76d0\u7530|\u6652\u76d0\u573a\n0604\u4ed3\u50a8|\u7269\u6d41\u4ed3\u5e93\n\n07 \u4f4f\u5b85\n0701\u57ce\u9547\u4f4f\u5b85|\u5546\u54c1\u623f\u7b49\n0702\u519c\u6751\u4f4f\u5b85|\u6751\u6c11\u81ea\u5efa\u623f\n\n08 \u516c\u5171\u7ba1\u7406\u670d\u52a1\n0801\u673a\u5173\u56e2\u4f53|\u653f\u5e9c\u5355\u4f4d\n0802\u6559\u80b2|\u5b66\u6821\n0803\u79d1\u7814|\u7814\u7a76\u6240\n0804\u533b\u7597|\u533b\u9662\n0805\u6587\u4f53|\u535a\u7269\u9986\u4f53\u80b2\u9986\n0806\u516c\u56ed\u7eff\u5730|\u516c\u5171\u7eff\u5730\n\n09 \u7279\u6b8a\u7528\u5730\n0901\u519b\u4e8b|\u57fa\u5730\u9776\u573a\n0902\u5b97\u6559|\u5bfa\u5e99\u6559\u5802\n0903\u6ba1\u846c|\u5893\u5730\u9675\u56ed\n0904\u98ce\u666f\u540d\u80dc|\u666f\u533a\n\n10 \u4ea4\u901a\u8fd0\u8f93\n1001\u94c1\u8def|\u7ebf\u8def\u573a\u7ad9\n1002\u8f68\u9053\u4ea4\u901a|\u5730\u94c1\u8f7b\u8f68\n1003\u516c\u8def|\u9ad8\u901f\u56fd\u9053\n1004\u57ce\u9547\u9053\u8def|\u5e02\u653f\u9053\u8def\n1005\u673a\u573a|\u822a\u7a7a\u8bbe\u65bd\n1006\u6e2f\u53e3\u7801\u5934|\u8d27\u8fd0\u5ba2\u8fd0\n1007\u7ba1\u9053\u8fd0\u8f93|\u6cb9\u6c14\u7ba1\u9053\n\n11 \u6c34\u57df\u6c34\u5229\n1101\u6cb3\u6d41|\u5929\u7136\u6cb3\u9053\n1102\u6e56\u6cca|\u5929\u7136\u6e56\n1103\u6c34\u5e93|\u4eba\u5de5\u6c34\u5e93\n1104\u5751\u5858|\u517b\u6b96\u5858\n1105\u6cbf\u6d77\u6ee9\u6d82|\u6f6e\u95f4\u5e26\n1106\u5185\u9646\u6ee9\u6d82|\u6cb3\u6e56\u6ee9\n1107\u6c9f\u6e20|\u704c\u6e89\u6e20\n1108\u6c34\u5de5\u5efa\u7b51|\u5824\u575d\u95f8\u7ad9\n\n12 \u5176\u4ed6\u571f\u5730\n1201\u7a7a\u95f2\u5730|\u672a\u5229\u7528\n1202\u8bbe\u65bd\u519c\u5730|\u6e29\u5ba4\u517b\u6b96\n1203\u7530\u574e|\u8015\u5730\u7530\u57c2\n1204\u76d0\u78b1\u5730|\u76d0\u78b1\u5316\n1205\u6cbc\u6cfd\u5730|\u6e7f\u5730\n1206\u6c99\u5730|\u6c99\u8986\u76d6\n1207\u88f8\u571f\u5730|\u65e0\u690d\u88ab";
    }

    private String getComment2009_2018() {
        return "\u6570\u636e\u5e74\u4efd\u4e3a2009-2018\u5e74\u95f4\u7684\u56fd\u571f\u8c03\u67e5\u6570\u636e\uff0c\u5730\u7c7b\u7f16\u7801\u5206\u7c7b\u6807\u51c6\uff1a\n01 \u8015\u5730\n011\u6c34\u7530|\u6c34\u6e90\u704c\u6e89,\u79cd\u6c34\u7a3b\u7b49\n012\u6c34\u6d47\u5730|\u704c\u6e89\u65f1\u4f5c,\u79cd\u5c0f\u9ea6\u852c\u83dc\n013\u65f1\u5730|\u65e0\u704c\u6e89,\u9760\u964d\u6c34\n\n02 \u56ed\u5730\n021\u679c\u56ed|\u82f9\u679c\u67d1\u6a58\u7b49\n022\u8336\u56ed|\u8336\u6811\n023\u5176\u4ed6\u56ed\u5730|\u6851\u6811\u6a61\u80f6\u7b49\n\n03 \u6797\u5730\n031\u6709\u6797\u5730|\u6811\u6728\u90c1\u95ed\u22650.2\n032\u704c\u6728\u6797|\u704c\u6728\u90c1\u95ed\u22650.4\n033\u5176\u4ed6\u6797|\u758f\u6797/\u82d7\u5703\u7b49\n\n04 \u8349\u5730\n041\u5929\u7136\u7267\u8349|\u5929\u7136\u8349\u672c\u755c\u7267\n042\u4eba\u5de5\u7267\u8349|\u4eba\u5de5\u79cd\u690d\n043\u5176\u4ed6\u8349\u5730|\u672a\u5229\u7528\u7b49\n\n05 \u5546\u670d\u7528\u5730\n051\u6279\u53d1\u96f6\u552e|\u5546\u573a\u5546\u94fa\n052\u4f4f\u5bbf\u9910\u996e|\u5bbe\u9986\u996d\u5e97\n053\u5546\u52a1\u91d1\u878d|\u5199\u5b57\u697c\u94f6\u884c\n054\u5176\u4ed6\u5546\u670d|\u5a31\u4e50\u52a0\u6cb9\u7ad9\n\n06 \u5de5\u77ff\u4ed3\u50a8\n061\u5de5\u4e1a|\u751f\u4ea7\u8bbe\u65bd\n062\u91c7\u77ff|\u91c7\u77f3\u91c7\u77ff\n063\u4ed3\u50a8|\u7269\u6d41\u5806\u573a\n\n07 \u4f4f\u5b85\n071\u57ce\u9547\u4f4f\u5b85|\u57ce\u5e02\u4f4f\u5b85\n072\u519c\u6751\u5b85\u57fa|\u6751\u6c11\u4f4f\u5b85\n\n08 \u516c\u5171\u7ba1\u7406\n081\u673a\u5173\u56e2\u4f53|\u653f\u5e9c\u5355\u4f4d\n082\u79d1\u6559\u6587\u536b|\u5b66\u6821\u533b\u9662\n083\u516c\u56ed\u7eff\u5730|\u516c\u5171\u7eff\u5730\n\n09 \u7279\u6b8a\u7528\u5730\n091\u519b\u4e8b|\u57fa\u5730\u9776\u573a\n092\u5b97\u6559|\u5bfa\u5e99\u6559\u5802\n093\u6ba1\u846c|\u5893\u5730\u9675\u56ed\n\n10 \u4ea4\u901a\n101\u94c1\u8def|\u7ebf\u8def\u573a\u7ad9\n102\u516c\u8def|\u9ad8\u901f\u56fd\u9053\n103\u673a\u573a|\u822a\u7a7a\u8bbe\u65bd\n104\u6e2f\u53e3|\u7801\u5934\n105\u7ba1\u9053|\u6cb9\u6c14\u7ba1\u9053\n\n11 \u6c34\u57df\n111\u6cb3\u6d41|\u5929\u7136\u6cb3\u9053\n112\u6e56\u6cca|\u5929\u7136\u6e56\n113\u6c34\u5e93|\u4eba\u5de5\u6c34\u5e93\n114\u5751\u5858|\u517b\u6b96\u5858\n115\u6cbf\u6d77\u6ee9\u6d82|\u6f6e\u95f4\u5e26\n116\u5185\u9646\u6ee9\u6d82|\u6cb3\u6e56\u6ee9\n117\u6c9f\u6e20|\u704c\u6e89\u6e20\n118\u6c34\u5de5|\u5824\u575d\u95f8\u7ad9\n\n12 \u5176\u4ed6\n121\u7a7a\u95f2|\u672a\u5229\u7528\n122\u8bbe\u65bd\u519c\u7528|\u6e29\u5ba4\u517b\u6b96\n123\u7530\u574e|\u8015\u5730\u7530\u57c2\n124\u76d0\u78b1|\u76d0\u78b1\u5730\n125\u6cbc\u6cfd|\u6e7f\u5730\n126\u6c99\u5730|\u6c99\u8986\u76d6\n127\u88f8\u5730|\u65e0\u690d\u88ab";
    }

    private String getJsonTempalte() {
        return "[{\"sql\": \"sql\u8bed\u53e5\",\"tableIds\": \"\u8868id\",\"isStat\":\"false/true\uff0cBool\u578b\uff0c\u662f\u5426\u7edf\u8ba1\"}]";
    }

    private String getSchema(List<AiCatalogDataNodeDTO> catalogDataNodes) {
        ArrayList schemaList = new ArrayList();
        for (AiCatalogDataNodeDTO catalogNode : catalogDataNodes) {
            if (catalogNode.getDataset() == null) {
                AppCatalogDataNodeDTO temp = (AppCatalogDataNodeDTO)this.appCatalogNodeService.getNodeDetail(catalogNode.getNodeId());
                BeanUtil.copyProperties((Object)temp, (Object)((Object)catalogNode), (String[])new String[0]);
            }
            HashMap<String, Object> schema = new HashMap<String, Object>();
            schema.put("\u8868\u540d\u79f0", catalogNode.getDataset().getName());
            schema.put("\u8868\u522b\u540d", catalogNode.getNodeName());
            schema.put("\u8868\u6807\u7b7e", catalogNode.getTypes() == null || catalogNode.getTypes().isEmpty() ? null : String.join((CharSequence)",", catalogNode.getTypes()));
            schema.put("\u8868id", catalogNode.getNodeId());
            schema.put("\u6570\u636e\u5e74\u4efd", catalogNode.getNodePhase());
            ArrayList fields = new ArrayList();
            for (CatalogDataNodeFieldsDTO column : catalogNode.getFields()) {
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("\u5b57\u6bb5\u540d", column.getName());
                field.put("\u5b57\u6bb5\u7c7b\u578b", FieldType.getByValue((Integer)column.getFieldType()).toString());
                field.put("\u5b57\u6bb5\u522b\u540d", StrUtil.isBlank((CharSequence)column.getAliasName()) ? column.getName() : column.getAliasName());
                fields.add(field);
            }
            schema.put("\u5b57\u6bb5\u5217\u8868", fields);
            schemaList.add(schema);
        }
        return JSONUtil.toJsonStr(schemaList);
    }

    private static class AiReturnResult {
        private String sql;
        private String tableIds;
        private boolean isStat;

        public String getSql() {
            return this.sql;
        }

        public String getTableIds() {
            return this.tableIds;
        }

        public boolean isStat() {
            return this.isStat;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setTableIds(String tableIds) {
            this.tableIds = tableIds;
        }

        public void setStat(boolean isStat) {
            this.isStat = isStat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AiReturnResult)) {
                return false;
            }
            AiReturnResult other = (AiReturnResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isStat() != other.isStat()) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            String this$tableIds = this.getTableIds();
            String other$tableIds = other.getTableIds();
            return !(this$tableIds == null ? other$tableIds != null : !this$tableIds.equals(other$tableIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AiReturnResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isStat() ? 79 : 97);
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            String $tableIds = this.getTableIds();
            result = result * 59 + ($tableIds == null ? 43 : $tableIds.hashCode());
            return result;
        }

        public String toString() {
            return "AiSqlTool.AiReturnResult(sql=" + this.getSql() + ", tableIds=" + this.getTableIds() + ", isStat=" + this.isStat() + ")";
        }
    }
}

