/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.queryrelation;

import com.alibaba.fastjson.JSON;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogLayerQueryService;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.field.FieldType;
import com.geoway.ns.ai.base.tool.AIToolParam;
import com.geoway.ns.ai.base.tool.AiBaseTool;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.tool.dto.AiCatalogDataNodeDTO;
import com.geoway.ns.ai.tool.queryrelation.QueryRelationToolDefinition;
import com.geoway.ns.ai.tool.queryrelation.QueryRelationToolParam;
import com.geoway.ns.ai.tool.queryrelation.QueryRelationToolResult;
import com.geoway.ns.ai.tool.util.AICatalogNodeUtil;
import com.geoway.ns.onemap.glfx.dto.GLFXResultDetail;
import com.geoway.ns.onemap.glfx.entity.TbGLFX;
import com.geoway.ns.onemap.glfx.service.TbGLFXService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRelationTool
extends AiBaseTool<QueryRelationToolParam, QueryRelationToolDefinition> {
    private GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);
    private AppCatalogLayerQueryService appCatalogLayerQueryService = (AppCatalogLayerQueryService)SpringContextUtil.getBean(AppCatalogLayerQueryService.class);
    private TbGLFXService tbGLFXService = (TbGLFXService)SpringContextUtil.getBean(TbGLFXService.class);

    private DataQueryResult getBaseInfo(AiCatalogDataNodeDTO relateTable, String tbbh) {
        String querySql = String.format("tbbh='%s'", tbbh);
        FeatureQueryFilterDTO featureQueryFilterDTO = new FeatureQueryFilterDTO();
        featureQueryFilterDTO.setReturnGeometry(Boolean.valueOf(true));
        featureQueryFilterDTO.setCondition(querySql);
        featureQueryFilterDTO.setNodeId(relateTable.getNodeId());
        DataQueryResult dataQueryResult = this.appCatalogLayerQueryService.queryData(featureQueryFilterDTO, null);
        FeatureResult featureResult = dataQueryResult.getData().stream().findFirst().orElse(null);
        if (featureResult == null) {
            return null;
        }
        dataQueryResult.setData(new ArrayList());
        dataQueryResult.getData().add(featureResult);
        dataQueryResult.setTotal(Long.valueOf(1L));
        return dataQueryResult;
    }

    private List<GLFXResultDetail> getRelInfo(TbGLFX glfx, FeatureResult featureResult) {
        HashMap requestParam = new HashMap();
        ArrayList blocks = new ArrayList();
        HashMap<String, Object> block = new HashMap<String, Object>();
        block.put("DK_ID", featureResult.getObjectId());
        block.put("WKID", "4490");
        block.put("WKT", featureResult.getGeometry());
        blocks.add(block);
        requestParam.put("Blocks", blocks);
        List glfxResults = this.tbGLFXService.analysis(requestParam, glfx.getName());
        return glfxResults;
    }

    protected AiToolResult call(QueryRelationToolParam param) {
        List<AiCatalogDataNodeDTO> relateTables = AICatalogNodeUtil.getCatalogNodesFromCache(this.aiToolContext);
        if (relateTables == null || relateTables.size() == 0) {
            return new AiToolResult("\u672a\u67e5\u8be2\u5230\u5173\u8054\u56fe\u5c42", null, (AIToolParam)param);
        }
        AiCatalogDataNodeDTO relateTable = relateTables.get(0);
        DataQueryResult baseInfo = this.getBaseInfo(relateTable, param.getTbId());
        if (baseInfo == null) {
            return new AiToolResult("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u6591\u4fe1\u606f", null, (AIToolParam)param);
        }
        List glfxfn = this.tbGLFXService.search(null);
        if (glfxfn == null || glfxfn.stream().filter(f -> f.getStatus() == true).count() == 0L) {
            return new AiToolResult("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5173\u8054\u65b9\u6848", null, (AIToolParam)param);
        }
        TbGLFX relSchema = glfxfn.stream().filter(f -> f.getStatus() == true).findFirst().get();
        List<GLFXResultDetail> relInfo = this.getRelInfo(relSchema, (FeatureResult)baseInfo.getData().get(0));
        QueryRelationToolResult relationResult = new QueryRelationToolResult();
        relationResult.setBaseInfo(baseInfo);
        relationResult.setRelInfo(relInfo);
        relationResult.setRelSchema(relSchema);
        String modelResult = String.format("\u5df2\u67e5\u8be2\u5230\u56fe\u5c42[%s]\u4e2d\u56fe\u6591\u7f16\u53f7\u4e3a[%s]\u7684\u5173\u8054\u4fe1\u606f,\u5176\u4e2d\u57fa\u672c\u4fe1\u606f\u5982\u4e0b\uff1a%s", relateTable.getNodeName(), param.getTbId(), JSON.toJSONString(this.wrapperResult(((FeatureResult)baseInfo.getData().get(0)).getAttributes(), relateTable)));
        return new AiToolResult(modelResult, (Object)relationResult, (AIToolParam)param);
    }

    private Map<String, Object> wrapperResult(Map<String, Object> result, AiCatalogDataNodeDTO aiCatalogDataNodeDTO) {
        HashMap<String, Object> realResult = new HashMap<String, Object>();
        for (Map.Entry<String, Object> mapEntry : result.entrySet()) {
            CatalogDataNodeFieldsDTO dataNodeFieldsDTO;
            if (aiCatalogDataNodeDTO.getFields() == null || (dataNodeFieldsDTO = (CatalogDataNodeFieldsDTO)aiCatalogDataNodeDTO.getFields().stream().filter(g -> g.getName().toUpperCase().equals(((String)mapEntry.getKey()).toUpperCase())).findFirst().orElse(null)) == null || dataNodeFieldsDTO.getFieldType().intValue() == FieldType.Shape.getValue() || dataNodeFieldsDTO == null) continue;
            realResult.put(dataNodeFieldsDTO.getAliasName(), mapEntry.getValue());
        }
        return realResult;
    }
}

