/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCompositeNodeDTO;
import com.geoway.adf.dms.catalog.dto.app.AppTimingNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.AppCatalogService;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.constant.ModelDatasetTypeEnum;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geosrv.ServiceType;
import com.geoway.adf.gis.tile.TileType;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiSystemMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.chat.message.AiUserMessage;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.tool.dto.AiCatalogDataNodeDTO;
import com.geoway.ns.ai.tool.filterlayer.FilterLayerToolResult;
import com.geoway.ns.ai.tool.querylayer.QueryLayerToolResult;
import com.geoway.ns.ai.tool.util.AIReturnContentUtil;
import com.geoway.ns.ai.tool.util.AgiParamConfigUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class AICatalogNodeUtil {
    private static AppCatalogNodeService appCatalogNodeService = (AppCatalogNodeService)SpringContextUtil.getBean(AppCatalogNodeService.class);
    private static AppCatalogService appCatalogService = (AppCatalogService)SpringContextUtil.getBean(AppCatalogService.class);
    private static final String KEY_MESSAGE_CATALOGNODE = "KEY_MESSAGE_QUERY_CATALOGNODE";
    private static final String KEY_ALL_CATALOGNODE = "KEY_ALL_CATALOGNODE";
    private static final ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)SpringContextUtil.getBean(ThreadPoolTaskExecutor.class);
    private static final String TOOL_CALL_catalogId = "catalogId";
    private static final String CATALOG_SELECT_PROMPT_JUSTNAME = "\u4efb\u52a1\u63cf\u8ff0\uff1a\u8bf7\u6839\u636e\u8f93\u5165\u5173\u952e\u8bcd\u5bf9\u56fe\u5c42\u5217\u8868\u8fdb\u884c\u5168\u6587\u68c0\u7d22\uff0c\u7b5b\u9009\u51fa\u76f8\u5173\u56fe\u5c42\u5e76\u6309\u5339\u914d\u5ea6\u6392\u5e8f\n\u8f93\u5165\u53c2\u6570\uff1a\n1\u3001\u5173\u952e\u8bcd\uff1a%s\n2\u3001\u56fe\u5c42\u5217\u8868(JSON\u683c\u5f0f):\n%s\n\u8f93\u51fa\u8981\u6c42\uff1a\n1\u3001\u4e25\u683c\u6309\u7167\u8f93\u51fa\u6837\u4f8b\u7684json\u7ed3\u6784\u8fd4\u56de\u5339\u914d\u7684\u56fe\u5c42\u5217\u8868,\n2\u3001\u6309\u5339\u914d\u5ea6\u964d\u5e8f\u6392\u5217,\n3\u3001\u652f\u6301\u6a21\u7cca\u5339\u914d(\u5982\u90e8\u5206\u5339\u914d\u3001\u540c\u4e49\u8bcd\u5339\u914d)\n4\u3001\u4e0d\u8f93\u51fa\u4efb\u4f55\u89e3\u91ca\u6027\u8bed\u8a00\u548c\u601d\u8003\u8fc7\u7a0b\n\u8f93\u51fa\u6837\u4f8b\uff1a\n[\n {\n   \"name\":\"\u5730\u7c7b\u56fe\u65912019\",\n   \"id\":\"1\"\n }\n]\n}]";
    private static final String TASK_PROMPT = "\u4efb\u52a1\u63cf\u8ff0\uff1a\u8bf7\u6839\u636e\u7528\u6237\u8f93\u5165\u5bf9\u56fe\u5c42\u5217\u8868\u8fdb\u884c\u5168\u6587\u68c0\u7d22\uff0c\u7b5b\u9009\u51fa\u76f8\u5173\u56fe\u5c42\u5e76\u6309\u5339\u914d\u5ea6\u6392\u5e8f";
    private static final Template LAYER_LIST_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u56fe\u5c42\u5217\u8868(json\u7ed3\u6784)\uff1a${tablelist}");
    private static final String RETURN_PROMPT = "\u8f93\u51fa\u8981\u6c42\uff1a\n1\u3001\u4e25\u683c\u6309\u7167\u8f93\u51fa\u6837\u4f8b\u7684json\u7ed3\u6784\u8fd4\u56de\u5339\u914d\u7684\u56fe\u5c42\u5217\u8868,\n2\u3001\u6309\u5339\u914d\u5ea6\u964d\u5e8f\u6392\u5217,\n3\u3001\u652f\u6301\u6a21\u7cca\u5339\u914d(\u5982\u90e8\u5206\u5339\u914d\u3001\u540c\u4e49\u8bcd\u5339\u914d)\n4\u3001\u4e0d\u8f93\u51fa\u4efb\u4f55\u89e3\u91ca\u6027\u8bed\u8a00\u548c\u601d\u8003\u8fc7\u7a0b";
    private static final Template RETURN_TEMPLATE_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u8f93\u51fa\u6837\u4f8b(json\u7ed3\u6784)\uff1a${template}");
    private static final String CATALOG_SELECT_PROMPT = "\u57fa\u4e8e\u7528\u6237\u95ee\u9898\u4e0e\u8868\u5143\u6570\u636e\u5339\u914d\u8bed\u4e49\u76f8\u5173\u8868\u7684\u64cd\u4f5c\u89c4\u8303\n\u8bf7\u4e25\u683c\u4f9d\u636e\u7528\u6237\u95ee\u9898\u53ca\u8868\u5143\u6570\u636e\uff0c\u7b5b\u9009\u6700\u7b26\u5408\u8bed\u4e49\u7684\u8868\u3002\u6267\u884c\u6d41\u7a0b\u5982\u4e0b\uff1a\n\n\u4e00\u3001\u4efb\u52a1\u6d41\u7a0b\n1.\u4f18\u5148\u7ea7\u5224\u65ad\n\n   - \u82e5\u95ee\u9898\u5305\u542b\u660e\u786e\u5e74\u4efd\uff0c\u5219\u5fc5\u987b\u540c\u65f6\u6ee1\u8db3\u5e74\u4efd\u5339\u914d\u4e0e\u8bed\u4e49\u5339\u914d\uff1b\u4ec5\u8fd4\u56de\u5305\u542b\u8be5\u5e74\u4efd\u7684\u8868\uff0c\u5ffd\u7565\u65e0\u5e74\u4efd\u6807\u6ce8\u7684\u8868\u3002\n   - \u652f\u6301\u8bc6\u522b\u591a\u79cd\u65f6\u95f4\u8303\u56f4\u8868\u8ff0\uff1a\"2010-2015\u5e74\"\u3001\"2010\u81f32015\u5e74\"\u3001\"2010~2015\u5e74\",\u89e3\u6790\u4e3a2010\u5e74\u30012011\u5e74\u30012012\u5e74\u30012013\u30012014\u5e74\u30012015\u5e74   - \u82e5\u95ee\u9898\u65e0\u660e\u786e\u5e74\u4efd\uff0c\u5219\u5e74\u4efd\u5b57\u6bb5\u4e0d\u53c2\u4e0e\u5339\u914d\u3002\n\n2.\u8bed\u4e49\u5339\u914d\n\n   - \u57fa\u4e8e\u95ee\u9898\u610f\u56fe\u5206\u6790\uff0c\u7efc\u5408\u8bc4\u4f30\u8868\u540d\u3001\u522b\u540d\u3001\u6807\u7b7e\u3001\u63cf\u8ff0\u53ca\u5e74\u4efd\u7684\u8bed\u4e49\u76f8\u5173\u6027\uff0c\u4f18\u5148\u8003\u8651\u7cbe\u786e\u5339\u914d\u3002\n\n3.\u76f8\u5173\u6027\u6392\u5e8f\n\n   - \u6309\u5339\u914d\u5f3a\u5ea6\u964d\u5e8f\u6392\u5217\u7ed3\u679c\u3002\n\n\u4e8c\u3001\u8f93\u51fa\u89c4\u8303\n    - \u683c\u5f0f\uff1a\u56fe\u5c42ID\u5217\u8868\uff08\u9017\u53f7\u5206\u9694\u65e0\u7a7a\u683c\uff09\uff0c\u4f8b\uff1aid1,id2,...\n    - \u8fc7\u6ee4\u8981\u6c42\uff1a\u4e25\u683c\u6392\u9664\u65e0\u5173\u7ed3\u679c\uff0c\u786e\u4fdd\u6bcf\u4e2a\u8fd4\u56de\u9879\u4e0e\u95ee\u9898\u5b58\u5728\u660e\u786e\u8bed\u4e49\u5173\u8054\u3002\n    - \u65e0\u5339\u914d\u65f6\uff1a\u8fd4\u56de\u65e0\u3002\n    - \u4e0d\u8981\u8f93\u51fa\u4efb\u4f55\u7684\u89e3\u91ca\u8bed\u8a00\u548c\u601d\u8003\u8fc7\u7a0b\u3002\n\u4e09\u3001\u5143\u6570\u636e\u5b57\u6bb5\u6743\u91cd\uff08\u8bed\u4e49\u5206\u6790\u4f18\u5148\u7ea7\uff09\n\u6309\u4ee5\u4e0b\u987a\u5e8f\u52a0\u6743\u5904\u7406\uff0c\u9ad8\u4f18\u5148\u7ea7\u5b57\u6bb5\u4e0d\u5339\u914d\u65f6\u76f4\u63a5\u8df3\u8fc7\u540e\u7eed\u8bc4\u4f30\uff1a\n\n    1.\u8868\u540d/\u522b\u540d\uff1a\u4f18\u5148\u7cbe\u786e\u5339\u914d\uff08\u5982\u95ee\u9898\u542b\u201c\u8015\u5730\u56fe\u6591\u201d\uff0c\u5219\u5339\u914d\u542b\u201c\u8015\u5730\u56fe\u6591\u201d\u7684\u8868\u540d\u6216\u522b\u540d\uff09\u3002\n    2.\u5e74\u4efd\uff1a\u95ee\u9898\u542b\u660e\u786e\u5e74\u4efd\u65f6\uff0c\u4ec5\u5339\u914d\u8be5\u5e74\u4efd\u7684\u8868\uff08\u5982\u95ee\u9898\u4e3a\u201c2018\u5e74\u201d\uff0c\u5219\u6392\u96642019\u5e74\u7b49\u975e\u76ee\u6807\u5e74\u4efd\u8868\uff09\u3002\n    3.\u63cf\u8ff0\uff1a\u8bc4\u4f30\u4e0a\u4e0b\u6587\u5173\u8054\u5ea6\uff08\u5982\u63cf\u8ff0\u4e2d\u9690\u542b\u95ee\u9898\u5173\u952e\u8bcd\u7684\u8bed\u4e49\u6269\u5c55\uff09\u3002\n    4.\u6807\u7b7e\uff1a\u6838\u5fc3\u5173\u952e\u8bcd\u5339\u914d\uff08\u5982\u6807\u7b7e\u542b\u201c\u56fd\u571f\u8c03\u67e5\u201d\u9700\u4e0e\u95ee\u9898\u610f\u56fe\u5f3a\u76f8\u5173\uff09\u3002\n    5.\u7a7a\u95f4\u7ef4\u5ea6\uff1a\u4e8c\u7ef4/\u4e09\u7ef4\u5c5e\u6027\u4e0e\u6570\u636e\u7c7b\u578b\u4f5c\u4e3a\u8f85\u52a9\u9a8c\u8bc1\uff08\u4ec5\u7528\u4e8e\u6700\u7ec8\u7ed3\u679c\u6821\u9a8c\uff0c\u4e0d\u4e3b\u5bfc\u5339\u914d\uff09\u3002\n\u56db\u3001\u8f93\u5165\u6570\u636e\n    \u53ef\u7528\u8868\u6e05\u5355\uff1a\n    %s\n    \u7528\u6237\u95ee\u9898\uff1a\n    \"%s\"\n\u4e94\u3001\u5904\u7406\u793a\u4f8b\n    \u95ee\u9898\uff1a\"\u67e5\u627e\u5b81\u590f\u77012018\u5e74\u7684\u8015\u5730\u56fe\u6591\u6570\u636e\"\n    \u5339\u914d\uff1adltb2018\uff08\u6807\u7b7e\u542b\"\u5730\u7c7b\u56fe\u6591\u3001\u56fd\u571f\u8c03\u67e5\"\uff0c\u63cf\u8ff0\u660e\u786e\u5173\u8054\u8015\u5730\u56fe\u6591\u53ca2018\u5e74\u56fd\u571f\u8c03\u67e5\uff09\n   \u4e0d\u5339\u914d\uff1adltb2019\uff08\u8bed\u4e49\u76f8\u5173\u4f46\u5e74\u4efd\u4e0d\u5339\u914d\uff0c\u8fdd\u53cd\u4f18\u5148\u7ea7\u89c4\u5219\uff09";

    public static List<AiCatalogDataNodeDTO> getCatalogNodesFromCache(AiToolContext aiToolContext) {
        if (aiToolContext.containsKey(KEY_MESSAGE_CATALOGNODE)) {
            return aiToolContext.getList(KEY_MESSAGE_CATALOGNODE, AiCatalogDataNodeDTO.class);
        }
        return new ArrayList<AiCatalogDataNodeDTO>();
    }

    public static List<AppCatalogNodeDTO> getCatalogNodes(String name, String years, AiToolContext aiToolContext, Consumer<AiMessage> messageConsumer) {
        long start = System.currentTimeMillis();
        String catalogId = "";
        if (aiToolContext.containsKey(KEY_MESSAGE_CATALOGNODE)) {
            return aiToolContext.getList(KEY_MESSAGE_CATALOGNODE, AppCatalogNodeDTO.class);
        }
        if (aiToolContext.containsKey(TOOL_CALL_catalogId) && aiToolContext.get(TOOL_CALL_catalogId, String.class) != null) {
            catalogId = (String)aiToolContext.getContext().get(TOOL_CALL_catalogId);
        }
        List<AppCatalogNodeDTO> nodeList = appCatalogNodeService.getLayerNodeList(catalogId, null);
        nodeList = nodeList.parallelStream().filter(f -> AICatalogNodeUtil.filterName(f, name)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)years) && !nodeList.isEmpty()) {
            List<String> yearList = Arrays.asList(years.split(","));
            ConcurrentLinkedQueue tableSet = new ConcurrentLinkedQueue();
            Integer size = 100;
            try {
                String split = AgiParamConfigUtil.getParam("layerSplit");
                size = Integer.parseInt(split);
            }
            catch (Exception e) {
                System.out.println("\u56fe\u5c42\u62c6\u5206\u6570\u91cf\u83b7\u53d6\u5931\u8d25\uff0c\u5df2\u9ed8\u8ba4\u4f7f\u7528100\u4f5c\u4e3a\u62c6\u5206\uff01");
            }
            List tablesList = CollectionUtil.split(nodeList, (int)size);
            CompletableFuture[] futures = (CompletableFuture[])tablesList.stream().map(m -> CompletableFuture.runAsync(() -> {
                List collect = m.stream().filter(f -> {
                    if (f instanceof AppCatalogDataNodeDTO) {
                        return yearList.contains(((AppCatalogDataNodeDTO)f).getNodePhase());
                    }
                    return false;
                }).collect(Collectors.toList());
                tableSet.addAll(collect);
            })).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
            nodeList = new ArrayList<AppCatalogNodeDTO>(tableSet);
        }
        if (!nodeList.isEmpty()) {
            FilterLayerToolResult callResult = new FilterLayerToolResult();
            callResult.setCatalogs(nodeList);
            String modelResult = String.format("\u627e\u5230\u4ee5\u4e0b\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u5c42\uff1a" + String.join((CharSequence)",", nodeList.stream().map(f -> f.getNodeName()).collect(Collectors.toList())), new Object[0]);
            AiToolMessage aiToolMessage = new AiToolMessage((Object)callResult, modelResult);
            if (messageConsumer != null) {
                messageConsumer.accept((AiMessage)aiToolMessage);
            }
        }
        System.out.println("\u56fe\u5c42\u8fc7\u6ee4\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        aiToolContext.put(KEY_MESSAGE_CATALOGNODE, nodeList);
        return nodeList;
    }

    private static boolean filterName(AppCatalogNodeDTO node, String keyword) {
        String[] desc;
        if (node.getNodeName().contains(keyword)) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)node.getDescribe()) && Arrays.stream(desc = node.getDescribe().split("[\u3001\uff0c,]")).anyMatch(f -> f.contains(keyword));
    }

    public static List<AiCatalogDataNodeDTO> getCatalogNodes(String message, String year, String dimension, AiToolContext aiToolContext, Consumer<AiMessage> messageConsumer) {
        long start = System.currentTimeMillis();
        if (aiToolContext.containsKey(KEY_MESSAGE_CATALOGNODE)) {
            return aiToolContext.getList(KEY_MESSAGE_CATALOGNODE, AiCatalogDataNodeDTO.class);
        }
        String catalogId = "";
        if (aiToolContext.containsKey(TOOL_CALL_catalogId) && aiToolContext.get(TOOL_CALL_catalogId, String.class) != null) {
            catalogId = (String)aiToolContext.getContext().get(TOOL_CALL_catalogId);
        }
        List<AiCatalogDataNodeDTO> allDataNodes = null;
        if (!aiToolContext.containsKey(KEY_ALL_CATALOGNODE)) {
            allDataNodes = AICatalogNodeUtil.getAllDataNodes(catalogId);
            aiToolContext.put(KEY_ALL_CATALOGNODE, (Object)allDataNodes);
        } else {
            allDataNodes = aiToolContext.getList(KEY_ALL_CATALOGNODE, AiCatalogDataNodeDTO.class);
        }
        List<AiCatalogDataNodeDTO> relateTables = allDataNodes;
        if (StrUtil.isNotBlank((CharSequence)year)) {
            List<String> years = Arrays.asList(year.split(","));
            relateTables = relateTables.stream().filter(f -> years.stream().anyMatch(g -> StrUtil.isNotBlank((CharSequence)f.getNodePhase()) && f.getNodePhase().startsWith((String)g))).collect(Collectors.toList());
        }
        if (StrUtil.isNotBlank((CharSequence)dimension)) {
            relateTables = relateTables.stream().filter(f -> AICatalogNodeUtil.getDataDimension(f).equalsIgnoreCase(dimension)).collect(Collectors.toList());
        }
        if (relateTables.size() > 0) {
            ConcurrentLinkedQueue tableSet = new ConcurrentLinkedQueue();
            Integer size = 100;
            try {
                String split = AgiParamConfigUtil.getParam("layerSplit");
                size = Integer.parseInt(split);
            }
            catch (Exception e) {
                System.out.println("\u56fe\u5c42\u62c6\u5206\u6570\u91cf\u83b7\u53d6\u5931\u8d25\uff0c\u5df2\u9ed8\u8ba4\u4f7f\u7528100\u4f5c\u4e3a\u62c6\u5206\uff01");
            }
            List tablesList = CollectionUtil.split(relateTables, (int)size);
            System.out.println("\u591a\u7ebf\u7a0b\u83b7\u53d6\u56fe\u5c42\uff0c\u5171\u8ba1" + tablesList.size() + "\u6279\u6b21 " + DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd HH:mm:ss"));
            CompletableFuture[] futures = (CompletableFuture[])tablesList.stream().map(m -> CompletableFuture.runAsync(() -> tableSet.addAll(AICatalogNodeUtil.getCatalogNodes(message, aiToolContext, m)), (Executor)taskExecutor)).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
            relateTables = tableSet.stream().collect(Collectors.toList());
            relateTables = AICatalogNodeUtil.getCatalogNodes(message, aiToolContext, relateTables);
            System.out.println(String.format("\u591a\u7ebf\u7a0b\u67e5\u8be2\u56fe\u5c42\u5b8c\u6210\uff01" + DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM-dd HH:mm:ss"), new Object[0]));
        }
        if (relateTables.size() != 0) {
            QueryLayerToolResult callResult = new QueryLayerToolResult();
            callResult.setCatalogs(relateTables);
            String modelResult = String.format("\u627e\u5230\u4ee5\u4e0b\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u5c42\uff1a" + String.join((CharSequence)",", relateTables.stream().map(f -> f.getNodeName()).collect(Collectors.toList())), new Object[0]);
            AiToolMessage aiToolMessage = new AiToolMessage((Object)callResult, modelResult);
            if (messageConsumer != null) {
                messageConsumer.accept((AiMessage)aiToolMessage);
            }
        }
        System.out.println("\u83b7\u53d6\u76f8\u5173\u8868\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        aiToolContext.put(KEY_MESSAGE_CATALOGNODE, relateTables);
        return relateTables;
    }

    private static List<AiCatalogDataNodeDTO> getCatalogNodes(String question, AiToolContext aiToolContext, List<AiCatalogDataNodeDTO> srcCatalogNodes) {
        ArrayList<AiCatalogDataNodeDTO> tarCatalogNodes = new ArrayList<AiCatalogDataNodeDTO>();
        if (srcCatalogNodes == null || srcCatalogNodes.size() == 0) {
            return tarCatalogNodes;
        }
        String tableList = AICatalogNodeUtil.getTableList(srcCatalogNodes);
        ArrayList<Object> aiMessages = new ArrayList<Object>();
        AiSystemMessage roleMessage = new AiSystemMessage(TASK_PROMPT);
        AiSystemMessage returnMessage = new AiSystemMessage(RETURN_PROMPT);
        AiSystemMessage tableListMessage = new AiSystemMessage(LAYER_LIST_PROMPT.render((Map)Dict.create().set("tablelist", (Object)tableList)));
        AiSystemMessage returnTemplateMessage = new AiSystemMessage(RETURN_TEMPLATE_PROMPT.render((Map)Dict.create().set("template", (Object)AICatalogNodeUtil.getReturnTemplate())));
        AiUserMessage userMessage = new AiUserMessage(question);
        aiMessages.add(roleMessage);
        aiMessages.add(returnMessage);
        aiMessages.add(tableListMessage);
        aiMessages.add(returnTemplateMessage);
        aiMessages.add(userMessage);
        AiChatClient chatClient = aiToolContext.getChatClient();
        try {
            AiChatResult result = chatClient.chat(aiMessages, null, aiToolContext);
            String queryResult = AIReturnContentUtil.removeThink(result.getContent());
            queryResult = AIReturnContentUtil.removeJson(queryResult);
            if (StrUtil.isNotBlank((CharSequence)queryResult) && JSONObject.isValidArray((String)queryResult)) {
                JSONArray jsonArray = JSONObject.parseArray((String)queryResult);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    int index = jsonObject.getInteger("id");
                    tarCatalogNodes.add(srcCatalogNodes.get(index));
                }
            }
            return tarCatalogNodes;
        }
        catch (Exception e) {
            System.out.println("\u591a\u7ebf\u7a0b\u67e5\u8be2\u56fe\u5c42\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return tarCatalogNodes;
        }
    }

    public static List<AiCatalogDataNodeDTO> getCatalogNodes(String question, AiToolContext aiToolContext, boolean withDetail, int limit) {
        if (aiToolContext.containsKey(KEY_MESSAGE_CATALOGNODE)) {
            return aiToolContext.getList(KEY_MESSAGE_CATALOGNODE, AiCatalogDataNodeDTO.class);
        }
        String catalogId = "";
        if (aiToolContext.containsKey(TOOL_CALL_catalogId) && aiToolContext.get(TOOL_CALL_catalogId, String.class) != null) {
            catalogId = (String)aiToolContext.get(TOOL_CALL_catalogId, String.class);
        }
        List tables = null;
        if (!aiToolContext.containsKey(KEY_ALL_CATALOGNODE)) {
            tables = AICatalogNodeUtil.getAllDataNodes(catalogId);
            aiToolContext.put(KEY_ALL_CATALOGNODE, (Object)tables);
        } else {
            tables = aiToolContext.getList(KEY_ALL_CATALOGNODE, AiCatalogDataNodeDTO.class);
        }
        ConcurrentHashSet tableSet = new ConcurrentHashSet();
        List tablesList = CollectionUtil.split((Collection)tables, (int)100);
        System.out.println("\u591a\u7ebf\u7a0b\u83b7\u53d6\u56fe\u5c42");
        CompletableFuture[] futures = (CompletableFuture[])tablesList.stream().map(m -> CompletableFuture.runAsync(() -> {
            List tableList = m.stream().map(f -> AICatalogNodeUtil.formatCatalogNodeMetadata(f)).collect(Collectors.toList());
            String prompt = String.format(CATALOG_SELECT_PROMPT, String.join((CharSequence)";\n ", tableList), question);
            AiChatClient chatClient = aiToolContext.getChatClient();
            try {
                AiChatResult result = chatClient.chat(prompt, aiToolContext);
                String queryResult = AIReturnContentUtil.removeThink(result.getContent());
                if (StrUtil.isNotBlank((CharSequence)queryResult)) {
                    String[] split = result.getContent().split(",\\s*");
                    tableSet.addAll(Arrays.asList(split));
                }
            }
            catch (Exception e) {
                System.out.println("\u591a\u7ebf\u7a0b\u67e5\u8be2\u56fe\u5c42\u5f02\u5e38\uff1a" + e.getMessage());
                e.printStackTrace();
            }
        }, (Executor)taskExecutor)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        if (tableSet.isEmpty()) {
            return new ArrayList<AiCatalogDataNodeDTO>();
        }
        List<AiCatalogDataNodeDTO> resultNodes = tables.stream().filter(f -> tableSet.contains((Object)f.getNodeId())).collect(Collectors.toList());
        if (withDetail) {
            resultNodes.forEach(f -> AICatalogNodeUtil.wrapper(f));
        }
        aiToolContext.put(KEY_MESSAGE_CATALOGNODE, resultNodes);
        return resultNodes;
    }

    public static void wrapper(AiCatalogDataNodeDTO aiCatalogDataNodeDTO) {
        if (aiCatalogDataNodeDTO == null) {
            return;
        }
        if (aiCatalogDataNodeDTO.getDataset() != null) {
            return;
        }
        AppCatalogNodeDTO appCatalogNodeDTO = appCatalogNodeService.getNodeDetail(aiCatalogDataNodeDTO.getNodeId());
        BeanUtil.copyProperties((Object)appCatalogNodeDTO, (Object)((Object)aiCatalogDataNodeDTO), (String[])new String[0]);
    }

    private static String formatCatalogNode_JUSTNAME(List<AiCatalogDataNodeDTO> aiCatalogDataNodeDTOS) {
        ArrayList names = new ArrayList();
        Integer index = 0;
        for (AiCatalogDataNodeDTO aiCatalogDataNodeDTO : aiCatalogDataNodeDTOS) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", aiCatalogDataNodeDTO.getNodeName());
            map.put("id", index.toString());
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            names.add(map);
        }
        return JSONObject.toJSONString(names);
    }

    private static String getReturnTemplate() {
        return "\n[\n   {\n     \"name\":\"\u5730\u7c7b\u56fe\u65912019\",\n     \"id\":\"1\"\n   }\n]";
    }

    private static String getTableList(List<AiCatalogDataNodeDTO> catalogDataNodeDTOS) {
        ArrayList catalogMaps = new ArrayList();
        int index = 0;
        for (AiCatalogDataNodeDTO catalogDataNodeDTO : catalogDataNodeDTOS) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("\u56fe\u5c42\u540d\u79f0", catalogDataNodeDTO.getNodeName());
            map.put("\u6807\u7b7e", catalogDataNodeDTO.getTypes() == null || catalogDataNodeDTO.getTypes().size() == 0 ? "\u65e0" : String.join((CharSequence)",", catalogDataNodeDTO.getTypes()));
            map.put("\u7a7a\u95f4\u7ef4\u5ea6", AICatalogNodeUtil.getDataDimension(catalogDataNodeDTO));
            map.put("\u6570\u636e\u7c7b\u578b", AICatalogNodeUtil.getDataType(catalogDataNodeDTO));
            map.put("\u63cf\u8ff0", catalogDataNodeDTO.getDescribe() == null ? "\u65e0" : catalogDataNodeDTO.getDescribe());
            map.put("\u5e74\u4efd", catalogDataNodeDTO.getNodePhase() == null ? "\u65e0" : catalogDataNodeDTO.getNodePhase());
            map.put("\u56fe\u5c42id", index);
            ++index;
            catalogMaps.add(map);
        }
        return JSONUtil.toJsonStr(catalogMaps);
    }

    private static String formatCatalogNodeMetadata(AiCatalogDataNodeDTO aiCatalogDataNodeDTO) {
        return String.format("\u8868\u540d:%s \u522b\u540d:%s \u6807\u7b7e:%s \u7a7a\u95f4\u7ef4\u5ea6\uff1a%s \u6570\u636e\u7c7b\u578b:%s \u63cf\u8ff0:%s \u5e74\u4efd:%s \u56fe\u5c42id:%s", aiCatalogDataNodeDTO.getNodeName(), aiCatalogDataNodeDTO.getNodeName(), aiCatalogDataNodeDTO.getTypes() == null || aiCatalogDataNodeDTO.getTypes().size() == 0 ? "\u65e0" : String.join((CharSequence)",", aiCatalogDataNodeDTO.getTypes()), AICatalogNodeUtil.getDataDimension(aiCatalogDataNodeDTO), AICatalogNodeUtil.getDataType(aiCatalogDataNodeDTO), aiCatalogDataNodeDTO.getDescribe() == null ? "\u65e0" : aiCatalogDataNodeDTO.getDescribe(), aiCatalogDataNodeDTO.getNodePhase() == null ? "\u65e0" : aiCatalogDataNodeDTO.getNodePhase(), aiCatalogDataNodeDTO.getNodeId());
    }

    private static String getDataDimension(AiCatalogDataNodeDTO aiCatalogDataNodeDTO) {
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)aiCatalogDataNodeDTO.getDatasetType());
        switch (datasetType) {
            case FeatureClass: 
            case Table: 
            case RasterDataset: 
            case MosaicDataset: 
            case DatumDataset: 
            case TableView: {
                return "\u4e8c\u7ef4";
            }
            case TileDataset: {
                TileType tileType = TileType.getByValue((Integer)aiCatalogDataNodeDTO.getTileType());
                switch (tileType) {
                    case RasterTile: {
                        return "\u4e8c\u7ef4";
                    }
                    case TerrainTile: {
                        return "\u4e09\u7ef4";
                    }
                    case Model3DTile: {
                        return "\u4e09\u7ef4";
                    }
                }
                return "\u4e8c\u7ef4";
            }
            case ModelDataset: {
                return "\u4e09\u7ef4";
            }
            case ServiceDataset: {
                ServiceType serviceType = ServiceType.getByValue((Integer)aiCatalogDataNodeDTO.getServiceType());
                switch (serviceType) {
                    case Aggregation: 
                    case VectorTileService: 
                    case WebMapService: 
                    case RasterTileService: 
                    case Unknown: 
                    case DTileService: 
                    case POIService: {
                        return "\u4e8c\u7ef4";
                    }
                    case TerrainService: 
                    case Annotation3dService: 
                    case Tiles3dService: {
                        return "\u4e09\u7ef4";
                    }
                }
            }
        }
        return "\u4e8c\u7ef4";
    }

    private static String getDataType(AiCatalogDataNodeDTO aiCatalogDataNodeDTO) {
        DatasetTypeEnum datasetType = DatasetTypeEnum.getByValue((Integer)aiCatalogDataNodeDTO.getDatasetType());
        switch (datasetType) {
            case FeatureClass: {
                FeatureType featureType = FeatureType.getByValue((Integer)aiCatalogDataNodeDTO.getFeatureType());
                switch (featureType) {
                    case Point: {
                        return "\u77e2\u91cf\u6570\u636e(\u70b9)";
                    }
                    case Polyline: {
                        return "\u77e2\u91cf\u6570\u636e(\u7ebf)";
                    }
                    case Annotation: {
                        return "\u77e2\u91cf\u6570\u636e(\u6ce8\u8bb0)";
                    }
                    case Polygon: 
                    case Unknown: 
                    case Mixed: {
                        return "\u77e2\u91cf\u6570\u636e(\u9762)";
                    }
                }
                break;
            }
            case Table: {
                return "\u666e\u901a\u6570\u636e\u5e93\u8868";
            }
            case TileDataset: {
                TileType tileType = TileType.getByValue((Integer)aiCatalogDataNodeDTO.getTileType());
                switch (tileType) {
                    case RasterTile: {
                        return "\u6805\u683c\u74e6\u7247";
                    }
                    case TerrainTile: {
                        return "\u4e09\u7ef4\u5730\u5f62\u74e6\u7247";
                    }
                    case Model3DTile: {
                        return "3dtile\u74e6\u7247";
                    }
                }
                break;
            }
            case RasterDataset: 
            case MosaicDataset: {
                return "\u5f71\u50cf\u6570\u636e";
            }
            case TableView: {
                return "\u6570\u636e\u5e93\u89c6\u56fe";
            }
            case DatumDataset: {
                return "\u6587\u4ef6\u6570\u636e\u96c6";
            }
            case ModelDataset: {
                ModelDatasetTypeEnum modelDatasetTypeEnum = ModelDatasetTypeEnum.getByValue((Integer)aiCatalogDataNodeDTO.getModelType());
                return modelDatasetTypeEnum.getDesc();
            }
            case ServiceDataset: {
                ServiceType serviceType = ServiceType.getByValue((Integer)aiCatalogDataNodeDTO.getServiceType());
                return serviceType.getDesc();
            }
        }
        return "\u77e2\u91cf\u6570\u636e(\u9762)";
    }

    private static List<AiCatalogDataNodeDTO> getAllDataNodes(String catalogId) {
        List appCatalogDTOS = appCatalogService.getAppCatalogList("", Boolean.valueOf(false));
        ArrayList<AiCatalogDataNodeDTO> result = new ArrayList<AiCatalogDataNodeDTO>();
        for (AppCatalogDTO appCatalogDTO : appCatalogDTOS) {
            if (StrUtil.isNotBlank((CharSequence)catalogId) && !appCatalogDTO.getId().equalsIgnoreCase(catalogId)) continue;
            AppCatalogNodeDTO resCatalogNodeDTO = appCatalogNodeService.getCatalogTree(appCatalogDTO.getId(), "", "", "", Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            ArrayList<String> types = new ArrayList<String>();
            AICatalogNodeUtil.getAllDataNodes(result, resCatalogNodeDTO.getChildren(), types);
        }
        return result;
    }

    private static void getAllDataNodes(List<AiCatalogDataNodeDTO> dataNodes, List<AppCatalogNodeDTO> catalogs, List<String> types) {
        if (catalogs == null) {
            return;
        }
        for (AppCatalogNodeDTO catalogNodeDTO : catalogs) {
            if (catalogNodeDTO.getChildren() != null && catalogNodeDTO.getChildren().size() > 0) {
                ArrayList<String> newTypes = new ArrayList<String>();
                newTypes.add(catalogNodeDTO.getNodeName());
                newTypes.addAll(types);
                AICatalogNodeUtil.getAllDataNodes(dataNodes, catalogNodeDTO.getChildren(), newTypes);
                continue;
            }
            if (catalogNodeDTO instanceof AppTimingNodeDTO) {
                AppTimingNodeDTO timingNodeDTO = (AppTimingNodeDTO)catalogNodeDTO;
                if (timingNodeDTO.getTimingNodes() == null) continue;
                AICatalogNodeUtil.getAllDataNodes(dataNodes, timingNodeDTO.getTimingNodes().stream().map(f -> f).collect(Collectors.toList()), types);
                continue;
            }
            if (catalogNodeDTO instanceof AppCompositeNodeDTO) {
                AppCompositeNodeDTO compositeNodeDTO = (AppCompositeNodeDTO)catalogNodeDTO;
                if (compositeNodeDTO.getCompositeChildren() == null) continue;
                AICatalogNodeUtil.getAllDataNodes(dataNodes, compositeNodeDTO.getCompositeChildren().stream().map(f -> f).collect(Collectors.toList()), types);
                continue;
            }
            if (!(catalogNodeDTO instanceof AppCatalogDataNodeDTO)) continue;
            try {
                AppCatalogDataNodeDTO resCatalogDataNodeDTO = (AppCatalogDataNodeDTO)catalogNodeDTO;
                if (resCatalogDataNodeDTO.getDatasetValid() != null && !resCatalogDataNodeDTO.getDatasetValid().booleanValue() || StrUtil.isBlank((CharSequence)resCatalogDataNodeDTO.getDatasetId())) continue;
                AiCatalogDataNodeDTO aiCatalogDataNodeDTO = new AiCatalogDataNodeDTO();
                BeanUtil.copyProperties((Object)resCatalogDataNodeDTO, (Object)((Object)aiCatalogDataNodeDTO), (String[])new String[0]);
                aiCatalogDataNodeDTO.setTypes(types);
                dataNodes.add(aiCatalogDataNodeDTO);
            }
            catch (Exception e) {}
        }
    }
}

