/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.analy.dto.TaskStatusInfoDTO;
import com.geoway.ns.analy.dto.TbZxfxTaskManageDTO;
import com.geoway.ns.analy.dto.ZxfxParamDTO;
import com.geoway.ns.analy.dto.ZxfxRequestDTO;
import com.geoway.ns.analy.entity.TbZxfxCatalog;
import com.geoway.ns.analy.entity.TbZxfxModel;
import com.geoway.ns.analy.entity.TbZxfxTaskManage;
import com.geoway.ns.analy.enums.ModelParamTypeEnum;
import com.geoway.ns.analy.enums.TaskStatusEnum;
import com.geoway.ns.analy.mapper.TbZxfxModelMapper;
import com.geoway.ns.analy.mapper.TbZxfxTaskManageMapper;
import com.geoway.ns.analy.service.AnalAsyncService;
import com.geoway.ns.analy.service.AnalysisNewService;
import com.geoway.ns.analy.service.TbZxfxCatalogService;
import com.geoway.ns.analy.service.TbZxfxModelService;
import com.geoway.ns.analy.service.TbZxfxTaskManageService;
import com.geoway.ns.analy.service.ZxfxCommonService;
import com.geoway.ns.analy.utils.BizCommonUtil;
import com.geoway.ns.analy.vo.TbZxfxTaskManageVO;
import com.geoway.ns.analy.vo.ZxfxResultListVO;
import com.geoway.ns.analy.vo.ZxfxTaskLogVO;
import com.geoway.ns.analy.vo.ZxfxTaskStatusStatVO;
import com.geoway.ns.sys.dto.PageDataResponse;
import com.geoway.ns.sys.dto.PageParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TbZxfxTaskManageServiceImpl
extends ServiceImpl<TbZxfxTaskManageMapper, TbZxfxTaskManage>
implements TbZxfxTaskManageService {
    @Autowired
    private TbZxfxCatalogService zxfxCatalogService;
    @Autowired
    private TbZxfxModelService zxfxModelService;
    @Autowired
    private TbZxfxModelMapper zxfxModelMapper;
    @Autowired
    private ZxfxCommonService zxfxCommonService;
    @Autowired
    private AnalAsyncService analAsyncService;
    @Autowired
    private DataSourceService dataSourceService;

    @Override
    public String saveOrUpInfo(TbZxfxTaskManageDTO dto) {
        TbZxfxTaskManage info = this.getInfo(dto);
        this.saveOrUpdate(info);
        return info.getId();
    }

    @Override
    public IPage<TbZxfxTaskManageVO> queryPage(PageParam pageParam, String name, String toolId, Integer status) {
        List<String> toolIds = StringUtils.isNotBlank((CharSequence)toolId) ? Arrays.asList(toolId.split(",")) : null;
        IPage<TbZxfxTaskManageVO> page = ((TbZxfxTaskManageMapper)this.baseMapper).queryPage(new Page((long)pageParam.getCurrent().intValue(), (long)pageParam.getSize().intValue()), name, toolIds, status);
        List records = page.getRecords();
        ArrayList<TbZxfxTaskManage> updateList = new ArrayList<TbZxfxTaskManage>();
        ArrayList<String> deleteList = new ArrayList<String>();
        for (TbZxfxTaskManageVO manage : records) {
            if (!TaskStatusEnum.QUEUE.value.equals(manage.getStatus()) && !TaskStatusEnum.RUNNING.value.equals(manage.getStatus())) continue;
            TbZxfxCatalog catalog = (TbZxfxCatalog)this.zxfxCatalogService.getById((Serializable)((Object)manage.getToolId()));
            TbZxfxModel model = (TbZxfxModel)this.zxfxModelService.getById((Serializable)((Object)catalog.getModelId()));
            AnalysisNewService analysisService = this.zxfxCommonService.findAnalysisService(model.getType());
            TaskStatusInfoDTO analysisInfo = analysisService.getAnalysisInfo(manage.getAnalysisId());
            if (analysisInfo != null) {
                manage.setStartTime(analysisInfo.getStartTime());
                manage.setEndTime(analysisInfo.getEndTime());
                manage.setProgress(analysisInfo.getProgress());
                manage.setStatus(analysisInfo.getStatus());
                updateList.add(TbZxfxTaskManage.builder().id(manage.getId()).startTime(manage.getStartTime()).endTime(manage.getEndTime()).progress(manage.getProgress()).status(manage.getStatus()).analysisParams(manage.getAnalysisParams()).toolId(manage.getToolId()).build());
                continue;
            }
            deleteList.add(manage.getId());
        }
        this.analAsyncService.updateTaskManageBatch(updateList);
        this.analAsyncService.deleteTaskManageBatch(deleteList);
        return page;
    }

    @Override
    public void deleteBatch(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idList = Arrays.asList(ids.split(","));
            this.removeByIds(idList);
        }
    }

    @Override
    public Boolean resetAnalysis(String id) {
        return null;
    }

    @Override
    public Object createTask(ZxfxRequestDTO dto) {
        TbZxfxCatalog catalog = (TbZxfxCatalog)this.zxfxCatalogService.getById((Serializable)((Object)dto.getToolId()));
        BizCommonUtil.objectVerify(catalog, "\u672a\u67e5\u8be2\u5230ID\u4e3a\u3010" + dto.getToolId() + "\u3011\u5728\u7ebf\u5206\u6790\u5de5\u5177\u8282\u70b9\uff01");
        String params = JSON.toJSONString(dto.getParam());
        String analysisId = this.analysis(catalog.getModelId(), dto.getParam());
        TbZxfxTaskManage build = TbZxfxTaskManage.builder().name(catalog.getName() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "-" + analysisId).toolId(dto.getToolId()).status(TaskStatusEnum.QUEUE.value).progress(0).analysisId(analysisId).analysisParams(params).build();
        this.save(build);
        return build.getId();
    }

    @Override
    public TbZxfxTaskManage getInfo(String id) {
        TbZxfxTaskManage taskManage = (TbZxfxTaskManage)this.getById((Serializable)((Object)id));
        BizCommonUtil.objectVerify(taskManage, "\u672a\u67e5\u8be2\u5230ID\u4e3a\u3010" + id + "\u3011\u4efb\u52a1\u4fe1\u606f\uff01");
        return taskManage;
    }

    @Override
    public List<ZxfxResultListVO> getResultList(String taskId) {
        ArrayList<ZxfxResultListVO> result = new ArrayList<ZxfxResultListVO>();
        TbZxfxTaskManage taskManage = (TbZxfxTaskManage)this.getById((Serializable)((Object)taskId));
        BizCommonUtil.objectVerify(taskManage, "\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u76f8\u5173\u4fe1\u606f\uff01");
        if (!TaskStatusEnum.SUCCESS.value.equals(taskManage.getStatus())) {
            throw new RuntimeException("\u5206\u6790\u672a\u5b8c\u6210\uff01");
        }
        String analysisParams = taskManage.getAnalysisParams();
        List zxfxParams = JSON.parseArray((String)analysisParams, ZxfxParamDTO.class);
        for (ZxfxParamDTO param : zxfxParams) {
            ZxfxResultListVO resultTable;
            if (!ModelParamTypeEnum.Output_LayerTable.type.equals(param.getType()) || (resultTable = this.getResultTable(param)) == null) continue;
            result.add(resultTable);
        }
        return result;
    }

    @Override
    public DataQueryResult getResultPage(PageParam pageParam, String dataSetId) {
        QueryFilterDTO queryFilterDTO = new QueryFilterDTO();
        queryFilterDTO.setPageIndex(Integer.valueOf(pageParam.getCurrent() - 1));
        queryFilterDTO.setRows(pageParam.getSize());
        DataQueryResult dataQueryResult = this.dataSourceService.queryData(dataSetId, queryFilterDTO);
        return dataQueryResult;
    }

    @Override
    public PageDataResponse<ZxfxTaskLogVO> queryLogInfo(PageParam pageParam, String taskId) throws Exception {
        TbZxfxTaskManage manage = (TbZxfxTaskManage)this.getById((Serializable)((Object)taskId));
        TbZxfxModel model = this.zxfxModelMapper.queryModelByToolId(manage.getToolId());
        AnalysisNewService analysisService = this.zxfxCommonService.findAnalysisService(model.getType());
        return analysisService.queryLogInfo(pageParam, manage.getAnalysisId());
    }

    @Override
    public ZxfxTaskStatusStatVO queryStatus() {
        return ((TbZxfxTaskManageMapper)this.baseMapper).queryStatus();
    }

    private ZxfxResultListVO getResultTable(ZxfxParamDTO param) {
        String val = param.getValue();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            String[] split = val.split(",");
            String tableName = "";
            tableName = split.length > 0 ? split[split.length - 1] : val;
            return ZxfxResultListVO.builder().resultName(tableName).resultValue(param.getDatasetId()).build();
        }
        return null;
    }

    private String analysis(String id, List<ZxfxParamDTO> param) {
        TbZxfxModel model = this.zxfxModelService.queryDetail(id);
        BizCommonUtil.objectVerify(model, "\u672a\u67e5\u8be2\u5230ID\u4e3a\u3010" + id + "\u3011\u6a21\u578b\u4fe1\u606f\uff01");
        AnalysisNewService analysisService = this.zxfxCommonService.findAnalysisService(model.getType());
        return analysisService.analysis(model, param);
    }

    private TbZxfxTaskManage getInfo(TbZxfxTaskManageDTO dto) {
        TbZxfxTaskManage build = TbZxfxTaskManage.builder().build();
        BeanUtil.copyProperties((Object)dto, (Object)build, (String[])new String[0]);
        return build;
    }
}

