/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.ns.analy.dto.TaskStatusInfoDTO;
import com.geoway.ns.analy.dto.ZxfxParamDTO;
import com.geoway.ns.analy.entity.TbZxfxModel;
import com.geoway.ns.analy.entity.TbZxfxModelParam;
import com.geoway.ns.analy.enums.ModelParamTypeEnum;
import com.geoway.ns.analy.service.AnalysisNewService;
import com.geoway.ns.analy.vo.TbZxfxModelVO;
import com.geoway.ns.analy.vo.ZxfxModelGroupVO;
import com.geoway.ns.analy.vo.ZxfxTaskLogVO;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.service.IDatabaseService;
import com.geoway.ns.geoserver3.service.IFlowService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import com.geoway.ns.sys.dto.PageDataResponse;
import com.geoway.ns.sys.dto.PageParam;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Geoserver3AnalysisServiceImpl
implements AnalysisNewService {
    @Autowired
    private IFlowService flowService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;
    @Autowired
    private IDatabaseService databaseService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;

    @Override
    public Integer getType() {
        return 2;
    }

    @Override
    public TbZxfxModel convertToModel(String serviceId) {
        TbAnalysisBaseInfo baseInfo = this.tbAnalysisBaseInfoService.findById(serviceId);
        TbZxfxModel model = new TbZxfxModel();
        model.setServiceId(baseInfo.getId());
        model.setName(baseInfo.getAlias());
        model.setDesc(baseInfo.getDesc());
        model.setType(this.getType());
        ServiceMetadataDAO metadataDAO = this.flowService.metadata(baseInfo.getName());
        List<TbZxfxModelParam> params = this.convertToModelParams(metadataDAO.getParamsInfo());
        model.setParams(params);
        return model;
    }

    @Override
    public String analysis(TbZxfxModel model, List<ZxfxParamDTO> params) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("taskName", model.getName() + "-" + System.currentTimeMillis());
        requestParams.put("taskDesc", model.getDesc());
        for (TbZxfxModelParam modelParam : model.getParams()) {
            this.convertParamValue(requestParams, model, modelParam, params);
        }
        TbAnalysisBaseInfo baseInfo = this.tbAnalysisBaseInfoService.findById(model.getServiceId());
        return this.flowService.analysis(requestParams, baseInfo.getName());
    }

    @Override
    public List<ZxfxModelGroupVO> getModelList(String name) {
        List lstBaseInfos = this.tbAnalysisBaseInfoService.findByType("flow");
        if (!StringUtils.isEmpty((CharSequence)name)) {
            lstBaseInfos = lstBaseInfos.stream().filter(p -> p.getAlias().contains(name)).collect(Collectors.toList());
        }
        List models = lstBaseInfos.stream().map(m -> TbZxfxModelVO.builder().id(m.getId()).name(m.getAlias()).groupId(m.getGroup()).build()).collect(Collectors.toList());
        Map<String, List<TbZxfxModelVO>> map = models.stream().collect(Collectors.groupingBy(TbZxfxModelVO::getGroupId));
        ArrayList<ZxfxModelGroupVO> lstModelGroups = new ArrayList<ZxfxModelGroupVO>();
        for (Map.Entry<String, List<TbZxfxModelVO>> entry : map.entrySet()) {
            lstModelGroups.add(ZxfxModelGroupVO.builder().id(entry.getKey()).name(entry.getKey()).desc(entry.getKey()).models(entry.getValue()).build());
        }
        return lstModelGroups;
    }

    @Override
    public TaskStatusInfoDTO getAnalysisInfo(String analysisId) {
        TbAnalysisTask task = this.flowService.task(analysisId);
        if (task == null) {
            return null;
        }
        TaskStatusInfoDTO statusInfo = TaskStatusInfoDTO.builder().progress((int)task.getProgress()).analysisId(analysisId).startTime(LocalDateTime.ofInstant(task.getStartTime().toInstant(), ZoneOffset.UTC)).build();
        if (task.getEndTime() != null) {
            statusInfo.setEndTime(LocalDateTime.ofInstant(task.getEndTime().toInstant(), ZoneOffset.UTC));
        }
        if (Objects.equals(task.getStatus(), 0)) {
            statusInfo.setStatus(1);
        } else if (Objects.equals(task.getStatus(), -1)) {
            statusInfo.setStatus(2);
        } else if (Objects.equals(task.getStatus(), 200)) {
            statusInfo.setStatus(3);
        } else {
            statusInfo.setStatus(4);
        }
        return statusInfo;
    }

    @Override
    public PageDataResponse<ZxfxTaskLogVO> queryLogInfo(PageParam pageParam, String analysisId) throws Exception {
        PageDataResponse response = new PageDataResponse();
        List logs = this.flowService.logs(analysisId);
        List collect = logs.stream().map(m -> {
            ZxfxTaskLogVO build = ZxfxTaskLogVO.builder().id(m.getId()).message(m.getLog()).taskId(m.getTaskId()).build();
            build.setTime(m.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            return build;
        }).collect(Collectors.toList());
        Collections.reverse(collect);
        response.setResult(collect);
        return response;
    }

    private List<TbZxfxModelParam> convertToModelParams(List<ServiceMetadataDAO.ParamInfo> paramInfos) {
        ArrayList<TbZxfxModelParam> params = new ArrayList<TbZxfxModelParam>();
        for (ServiceMetadataDAO.ParamInfo m : paramInfos) {
            if ("analysisID".equals(m.getName()) || "applicationGUID".equals(m.getName()) || "taskName".equals(m.getName()) || "taskDesc".equals(m.getName())) continue;
            TbZxfxModelParam param = new TbZxfxModelParam();
            param.setName(m.getName());
            param.setType(this.convertType(m.getType()));
            param.setOriginType(m.getType());
            param.setGroup(m.getGroup());
            param.setAlias(m.getAlias());
            param.setOriginAlias(m.getAlias());
            param.setGroup(m.getGroup());
            param.setDesc(m.getDescription());
            param.setEnable(1);
            param.setOrder(m.getOrder());
            param.setRequired(m.isRequired() ? 1 : 0);
            param.setDefaultValue(m.getDefaultValue());
            if (!StringUtils.isEmpty((CharSequence)m.getTag())) {
                JSONObject tagObj = JSON.parseObject((String)m.getTag());
                param.setPrecondition(tagObj.getString("precondition"));
                String source = tagObj.getString("source");
                if (!StringUtils.isEmpty((CharSequence)source)) {
                    JSONObject contentSetObj = new JSONObject();
                    contentSetObj.put("source", (Object)source);
                    param.setContentSet(contentSetObj.toJSONString());
                }
            }
            param.setParam(JSON.toJSONString((Object)m));
            params.add(param);
        }
        return params;
    }

    private String convertType(String type) {
        String onemap4Type = null;
        onemap4Type = "Boolean".equals(type) ? ModelParamTypeEnum.Boolean.type : ("String".equals(type) || "MultiString".equals(type) ? ModelParamTypeEnum.String.type : ("Number".equals(type) ? ModelParamTypeEnum.Numeric.type : ("Timestamp".equals(type) ? ModelParamTypeEnum.Datetime.type : ("Database".equals(type) || "SDatabase".equals(type) || "RDatabase".equals(type) ? ModelParamTypeEnum.SDatebase.type : ("Table".equals(type) || "Layer".equals(type) || "LayerOrTable".equals(type) ? ModelParamTypeEnum.Node.type : ("Filed".equals(type) || "CaculateFiled".equals(type) ? ModelParamTypeEnum.Field.type : ("Fields".equals(type) || "CaculateFileds".equals(type) ? ModelParamTypeEnum.Fields.type : ("WhereClause".equals(type) || "SQL".equals(type) ? ModelParamTypeEnum.WhereClause.type : ("SpatialBlocks".equals(type) || "SpatialBlock".equals(type) ? ModelParamTypeEnum.SpatialRange.type : ("StatFileds".equals(type) ? ModelParamTypeEnum.StatField.type : ("QueryFileds".equals(type) ? ModelParamTypeEnum.GroupField.type : ModelParamTypeEnum.String.type)))))))))));
        return onemap4Type;
    }

    private void convertParamValue(Map<String, Object> requestParams, TbZxfxModel model, TbZxfxModelParam modelParam, List<ZxfxParamDTO> params) {
        ModelParamTypeEnum paramType = ModelParamTypeEnum.getEnumByType(modelParam.getType());
        Optional<ZxfxParamDTO> optional = params.stream().filter(p -> Objects.equals(modelParam.getName(), p.getName())).findFirst();
        if (paramType == ModelParamTypeEnum.Unknown || optional == null || !optional.isPresent()) {
            return;
        }
        String originValue = optional.get().getValue();
        switch (paramType) {
            case SDatebase: {
                if (!this.databaseService.addDatabase(originValue)) {
                    throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
                }
                requestParams.put(modelParam.getName(), originValue);
                break;
            }
            case Node: 
            case ComboYearNode: {
                JSONObject contentSetObj;
                String source;
                ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(originValue);
                ResCatalogDataNodeDTO resCatalogDataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
                FeatureClassDTO featureDatasetDTO = (FeatureClassDTO)resCatalogDataNodeDTO.getDataset();
                if (!this.databaseService.addDatabase(resCatalogDataNodeDTO.getDataset().getDsKey())) {
                    throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u65b0\u589e\u6570\u636e\u6e90\u5931\u8d25");
                }
                if (!StringUtils.isEmpty((CharSequence)modelParam.getContentSet()) && !StringUtils.isEmpty((CharSequence)(source = (contentSetObj = JSON.parseObject((String)modelParam.getContentSet())).getString("source")))) {
                    requestParams.put(source, resCatalogDataNodeDTO.getDataset().getDsKey());
                }
                requestParams.put(modelParam.getName(), featureDatasetDTO.getName());
                break;
            }
            case SpatialRange: {
                requestParams.put(modelParam.getName(), originValue);
                break;
            }
            case GroupField: 
            case StatField: {
                JSONArray array = JSONObject.parseArray((String)originValue);
                requestParams.put(modelParam.getName(), array);
                break;
            }
            default: {
                requestParams.put(modelParam.getName(), originValue);
            }
        }
    }
}

