/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.ns.analy.dto.ZxfxParamDTO;
import com.geoway.ns.analy.entity.TbZxfxModel;
import com.geoway.ns.analy.entity.TbZxfxModelParam;
import com.geoway.ns.analy.entity.TbZxfxTaskManage;
import com.geoway.ns.analy.enums.ModelParamTypeEnum;
import com.geoway.ns.analy.enums.ModelTypeEnum;
import com.geoway.ns.analy.enums.TaskStatusEnum;
import com.geoway.ns.analy.mapper.TbZxfxModelMapper;
import com.geoway.ns.analy.mapper.TbZxfxModelParamMapper;
import com.geoway.ns.analy.mapper.TbZxfxTaskManageMapper;
import com.geoway.ns.analy.service.AnalAsyncService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Async(value="oneMapThreadPoolTaskExecutor")
public class AnalAsyncServiceImpl
implements AnalAsyncService {
    @Autowired
    private TbZxfxTaskManageMapper zxfxTaskManageMapper;
    @Autowired
    private TbZxfxModelMapper zxfxModelMapper;
    @Autowired
    private TbZxfxModelParamMapper tbZxfxModelParamMapper;
    @Autowired
    private GeoDatabaseService geoDatabaseService;

    @Override
    public void updateTaskManageBatch(List<TbZxfxTaskManage> list) {
        for (TbZxfxTaskManage manage : list) {
            String analysisParams = manage.getAnalysisParams();
            TbZxfxModel model = this.zxfxModelMapper.queryModelByToolId(manage.getToolId());
            List zxfxParams = JSON.parseArray((String)analysisParams, ZxfxParamDTO.class);
            if (TaskStatusEnum.SUCCESS.value.equals(manage.getStatus())) {
                try {
                    this.register(zxfxParams, model);
                }
                catch (Exception e) {
                    manage.setBz("\u5143\u6570\u636e\u6ce8\u518c\u5931\u8d25\uff01\u3010" + e.getMessage() + "\u3011");
                }
            }
            manage.setAnalysisParams(JSON.toJSONString((Object)zxfxParams));
            this.zxfxTaskManageMapper.updateById(manage);
        }
    }

    @Override
    public void deleteTaskManageBatch(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            this.zxfxTaskManageMapper.deleteBatchIds(ids);
        }
    }

    private void register(List<ZxfxParamDTO> zxfxParams, TbZxfxModel model) {
        for (ZxfxParamDTO param : zxfxParams) {
            if (!ModelParamTypeEnum.Output_LayerTable.type.equals(param.getType())) continue;
            if (ModelTypeEnum.ATLAS.value == model.getType()) {
                this.atlasRegister(param);
                continue;
            }
            this.geoserverRegister(param, model, zxfxParams);
        }
    }

    private void geoserverRegister(ZxfxParamDTO param, TbZxfxModel model, List<ZxfxParamDTO> params) {
        TbZxfxModelParam modelParam = (TbZxfxModelParam)this.tbZxfxModelParamMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxModelParam.class).eq(TbZxfxModelParam::getModelId, (Object)model.getId())).eq(TbZxfxModelParam::getName, (Object)param.getName()));
        String contentSet = modelParam.getContentSet();
        JSONObject json = JSON.parseObject((String)contentSet);
        String paramName = json.getString("source");
        ZxfxParamDTO dto = params.stream().filter(f -> f.getName().equals(paramName)).findFirst().orElse(null);
        String datasetId = this.geoDatabaseService.synchronizeDataset(dto.getValue(), param.getValue());
        param.setDatasetId(datasetId);
    }

    private void atlasRegister(ZxfxParamDTO param) {
        String value = param.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] split = value.split(",");
            String tableName = split[split.length - 1];
            String dbKey = split[0];
            String datasetId = this.geoDatabaseService.synchronizeDataset(dbKey, tableName);
            param.setDatasetId(datasetId);
        }
    }
}

