/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.analy.entity.TbZxfxCatalog;
import com.geoway.ns.analy.entity.TbZxfxTaskManage;
import com.geoway.ns.analy.enums.CatalogTypeEnum;
import com.geoway.ns.analy.mapper.TbZxfxCatalogMapper;
import com.geoway.ns.analy.mapper.TbZxfxTaskManageMapper;
import com.geoway.ns.analy.service.TbZxfxCatalogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbZxfxCatalogServiceImpl
extends ServiceImpl<TbZxfxCatalogMapper, TbZxfxCatalog>
implements TbZxfxCatalogService {
    @Autowired
    private TbZxfxCatalogMapper tbZxfxCatalogMapper;
    @Autowired
    private TbZxfxTaskManageMapper zxfxTaskManageMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateInfo(TbZxfxCatalog zxfxCatalog) {
        if (StringUtils.isBlank((CharSequence)zxfxCatalog.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)zxfxCatalog.getSchemeId())) {
            throw new RuntimeException("\u65b9\u6848ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)zxfxCatalog.getPId())) {
            zxfxCatalog.setPId("-1");
        }
        if (zxfxCatalog.getType().equals(2) && StringUtils.isEmpty((CharSequence)zxfxCatalog.getModelId())) {
            throw new RuntimeException("\u6a21\u578b\u8282\u70b9\u7684modelId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TbZxfxCatalog exist = (TbZxfxCatalog)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getName, (Object)zxfxCatalog.getName())).eq(TbZxfxCatalog::getPId, (Object)zxfxCatalog.getPId())).eq(TbZxfxCatalog::getType, (Object)zxfxCatalog.getType())).eq(TbZxfxCatalog::getSchemeId, (Object)zxfxCatalog.getSchemeId()));
        if (StringUtils.isEmpty((CharSequence)zxfxCatalog.getId())) {
            if (exist != null && exist.getPId().equals(zxfxCatalog.getPId())) {
                throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
            }
            zxfxCatalog.setId(UUID.randomUUID().toString());
            Integer order = this.tbZxfxCatalogMapper.selectMaxOrder(zxfxCatalog.getSchemeId(), zxfxCatalog.getPId());
            order = order == null ? 1 : order + 1;
            zxfxCatalog.setOrder(order);
            return this.save(zxfxCatalog);
        }
        if (exist != null && exist.getPId().equals(zxfxCatalog.getPId()) && !exist.getId().equals(zxfxCatalog.getId())) {
            throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
        }
        return this.updateById(zxfxCatalog);
    }

    @Override
    public List<TbZxfxCatalog> queryTree(String schemeId, String name) {
        List<TbZxfxCatalog> list = ((TbZxfxCatalogMapper)this.baseMapper).queryList(schemeId, name);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            ArrayList<TbZxfxCatalog> parents = new ArrayList<TbZxfxCatalog>();
            for (TbZxfxCatalog catalog : list) {
                this.queryParentLoop(parents, catalog.getPId());
            }
            for (TbZxfxCatalog parent : parents) {
                if (list.stream().anyMatch(p -> p.getId().equals(parent.getId()))) continue;
                list.add(parent);
            }
        }
        return this.constructTree(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        TbZxfxCatalog catalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (catalog == null) {
            throw new RuntimeException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        return this.deleteCatalogLoop(catalog);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        String[] idsArray;
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        for (String id : idsArray = ids.split(",")) {
            TbZxfxCatalog catalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
            if (catalog == null) continue;
            this.deleteCatalogLoop(catalog);
        }
        return true;
    }

    @Override
    public boolean deleteBySchemeId(String schemeId) {
        return this.remove((Wrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getSchemeId, (Object)schemeId));
    }

    @Override
    public boolean moveToFirst(String id) {
        return this.sort(id, 1);
    }

    @Override
    public boolean moveToLast(String id) {
        TbZxfxCatalog curCatalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        TbZxfxCatalog maxCatalog = (TbZxfxCatalog)this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZxfxCatalog::getPId, (Object)curCatalog.getPId())).orderByDesc(TbZxfxCatalog::getOrder)).get(0);
        return this.sort(id, maxCatalog.getOrder());
    }

    @Override
    public boolean moveToPre(String id) {
        TbZxfxCatalog curCatalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        if (curCatalog.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() - 1);
    }

    @Override
    public boolean moveToNext(String id) {
        TbZxfxCatalog curCatalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return false;
        }
        int maxOrder = this.tbZxfxCatalogMapper.selectMaxOrder(curCatalog.getSchemeId(), curCatalog.getPId());
        if (curCatalog.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, curCatalog.getOrder() + 1);
    }

    @Override
    public boolean sort(String id, int order) {
        TbZxfxCatalog curCatalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return true;
        }
        if (curCatalog.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curCatalog.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZxfxCatalog::getPId, (Object)curCatalog.getPId())).ge(TbZxfxCatalog::getOrder, (Object)order)).lt(TbZxfxCatalog::getOrder, (Object)curCatalog.getOrder())).orderByAsc(TbZxfxCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZxfxCatalog)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).eq(TbZxfxCatalog::getPId, (Object)curCatalog.getPId())).gt(TbZxfxCatalog::getOrder, (Object)curCatalog.getOrder())).le(TbZxfxCatalog::getOrder, (Object)order)).orderByAsc(TbZxfxCatalog::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZxfxCatalog)needUpdateList.get(i)).setOrder(curCatalog.getOrder() + i);
            }
        }
        curCatalog.setOrder(order);
        needUpdateList.add(curCatalog);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public boolean sort(String id, int order, String pid) {
        TbZxfxCatalog curCatalog = (TbZxfxCatalog)this.getById((Serializable)((Object)id));
        if (curCatalog == null) {
            return true;
        }
        if (curCatalog.getPId().equals(pid) && curCatalog.getOrder().equals(order)) {
            return true;
        }
        if (!curCatalog.getPId().equals(pid)) {
            this.verifyName(curCatalog.getSchemeId(), pid, curCatalog.getName());
        }
        Boolean flag = curCatalog.getPId().equals(pid) && curCatalog.getOrder() < order;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getPId, (Object)pid)).eq(TbZxfxCatalog::getSchemeId, (Object)curCatalog.getSchemeId())).ne(TbZxfxCatalog::getId, (Object)id)).orderByAsc(TbZxfxCatalog::getOrder);
        if (curCatalog.getPId().equals(pid)) {
            if (flag.booleanValue()) {
                ((LambdaQueryWrapper)wrapper.le(TbZxfxCatalog::getOrder, (Object)order)).gt(TbZxfxCatalog::getOrder, (Object)curCatalog.getOrder());
            } else {
                ((LambdaQueryWrapper)wrapper.ge(TbZxfxCatalog::getOrder, (Object)order)).lt(TbZxfxCatalog::getOrder, (Object)curCatalog.getOrder());
            }
        } else {
            wrapper.ge(TbZxfxCatalog::getOrder, (Object)order);
        }
        List needUpdateList = this.list((Wrapper)wrapper);
        needUpdateList.forEach(f -> f.setOrder(flag != false ? f.getOrder() - 1 : f.getOrder() + 1));
        curCatalog.setPId(pid);
        curCatalog.setOrder(order);
        needUpdateList.add(curCatalog);
        return this.updateBatchById(needUpdateList);
    }

    private void verifyName(String schemeId, String pid, String name) {
        TbZxfxCatalog catalog = (TbZxfxCatalog)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getSchemeId, (Object)schemeId)).eq(TbZxfxCatalog::getPId, (Object)pid)).eq(TbZxfxCatalog::getName, (Object)name));
        if (ObjectUtil.isNotEmpty((Object)catalog)) {
            throw new RuntimeException("\u8be5\u5c42\u7ea7\u5b58\u5728\u540c\u540d\u8282\u70b9");
        }
    }

    private List<TbZxfxCatalog> constructTree(List<TbZxfxCatalog> list) {
        ArrayList<TbZxfxCatalog> roots = new ArrayList<TbZxfxCatalog>();
        for (TbZxfxCatalog catalog : list) {
            List<TbZxfxCatalog> children = list.stream().filter(p -> p.getPId().equals(catalog.getId())).collect(Collectors.toList());
            catalog.setChildren(children);
            if (!"-1".equals(catalog.getPId())) continue;
            roots.add(catalog);
        }
        return roots;
    }

    private void queryParentLoop(List<TbZxfxCatalog> parents, String pId) {
        if ("-1".equals(pId)) {
            return;
        }
        TbZxfxCatalog parent = (TbZxfxCatalog)this.getById((Serializable)((Object)pId));
        if (parent == null) {
            return;
        }
        parents.add(parent);
        this.queryParentLoop(parents, parent.getPId());
    }

    private boolean deleteCatalogLoop(TbZxfxCatalog catalog) {
        List children = this.list((Wrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getPId, (Object)catalog.getId()));
        if (children != null && children.size() > 0) {
            for (TbZxfxCatalog child : children) {
                this.deleteCatalogLoop(child);
            }
        }
        if (CatalogTypeEnum.MODEL.value == catalog.getType()) {
            this.zxfxTaskManageMapper.delete((Wrapper)Wrappers.lambdaQuery(TbZxfxTaskManage.class).eq(TbZxfxTaskManage::getToolId, (Object)catalog.getId()));
        }
        return this.removeById((Serializable)((Object)catalog.getId()));
    }
}

