/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.base.util;

import cn.hutool.crypto.digest.SM3;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CommonsUtil {

    public static class TypeCast {
        public static String toString(Object obj) {
            return String.valueOf(obj);
        }

        public static double toDouble(Object obj) {
            if (obj == null) {
                return 0.0;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            return Double.valueOf(obj.toString());
        }

        public static int toInt(Object obj) {
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return Integer.valueOf(obj.toString());
        }
    }

    public static class Hex {
        public static String getHexSM3(Object ... keys) {
            StringBuilder sbl = new StringBuilder();
            for (Object key : keys) {
                if (key == null) {
                    sbl.append("");
                    continue;
                }
                if (key instanceof String) {
                    sbl.append((String)key);
                    continue;
                }
                sbl.append(key);
            }
            return SM3.create().digestHex(sbl.toString());
        }
    }

    public static class Threads {
        public static void sleep(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Lists {
        public static <T, U extends Comparable<? super U>> List<T> distnctList(List<T> list, Function<? super T, ? extends U> keyExtractor) {
            return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(Comparator.comparing(keyExtractor))), ArrayList::new));
        }

        public static <T, K, U> Map toMap(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
            return list.stream().collect(Collectors.toMap(keyMapper, valueMapper));
        }

        public static <T> List<T> distinctListFilter(List<T> tList, Function<? super T, ?> keyExtractor) {
            if (null != tList) {
                return tList.stream().filter(Lists.distinctByVariable(u -> keyExtractor.apply(u))).collect(Collectors.toList());
            }
            return null;
        }

        public static <T, K, U> List<U> distinctListUnion(List<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
            return list.stream().collect(Collectors.toMap(keyMapper, valueMapper, mergeFunction)).values().stream().collect(Collectors.toList());
        }

        public static <T> T filter(List<T> list, Predicate<? super T> predicate) {
            return list.stream().filter(predicate).findFirst().orElse(null);
        }

        private static <T> Predicate<T> distinctByVariable(Function<? super T, ?> keyExtractor) {
            HashMap map = new HashMap();
            return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        }
    }

    public static class BigDecimals {
        public static double scale(double num, int scale, int roundingMode) {
            if (num > 0.0) {
                num = new BigDecimal(num).setScale(scale, roundingMode).doubleValue();
            }
            return num;
        }

        public static double scale(double num, int scale) {
            return BigDecimals.scale(num, scale, 1);
        }

        public static double scale(double num) {
            return BigDecimals.scale(num, 2, 1);
        }

        public static double subDouble(double a, double b) {
            BigDecimal sub = BigDecimal.valueOf(a);
            BigDecimal minuend = BigDecimal.valueOf(b);
            return sub.subtract(minuend).doubleValue();
        }

        public static double sumDouble(double a, double b) {
            BigDecimal addend = BigDecimal.valueOf(a);
            BigDecimal augend = BigDecimal.valueOf(b);
            return addend.add(augend).doubleValue();
        }

        public static double divDouble(double a, double b, Integer scale, Integer roundingMode) {
            BigDecimal addend = BigDecimal.valueOf(a);
            BigDecimal augend = BigDecimal.valueOf(b);
            roundingMode = roundingMode == null ? 1 : roundingMode;
            return addend.divide(augend, (int)scale, roundingMode).doubleValue();
        }

        public static double divDouble(double a, double b, Integer scale) {
            return BigDecimals.divDouble(a, b, scale, 1);
        }

        public static double divDouble(double a, double b) {
            return BigDecimals.divDouble(a, b, 15, 1);
        }

        public static double mulDouble(double a, double b) {
            BigDecimal addend = BigDecimal.valueOf(a);
            BigDecimal augend = BigDecimal.valueOf(b);
            return addend.multiply(augend).doubleValue();
        }
    }

    public static class Times {
        public static Long getEpochSecond() {
            return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).getEpochSecond();
        }

        public static Long getEpochMilli() {
            return LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }

        public static double getCost(Date start, Date end) {
            return (double)(end.getTime() - start.getTime()) / 1000.0;
        }

        public static void overtime(Date start, Integer second) {
            Date end = new Date();
            double cost = (double)(end.getTime() - start.getTime()) / 1000.0;
            if (cost > (double)second.intValue()) {
                throw new RuntimeException("\u7ed3\u679c\u83b7\u53d6\u8d85\u65f6\uff01");
            }
        }

        public static void overtime(Date start, Integer second, String msg) {
            Date end = new Date();
            double cost = (double)(end.getTime() - start.getTime()) / 1000.0;
            if (cost > (double)second.intValue()) {
                throw new RuntimeException(msg);
            }
        }
    }
}

