/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.base.util;

public class GaussXY2BL {
    public static int Beijing54 = 0;
    public static int Xian80 = 1;
    public static int CGCS2000 = 2;

    public static double[] selectCoordinateParam(int coordinateName) {
        double[] output = new double[2];
        switch (coordinateName) {
            case 0: {
                output[0] = 6378245.0;
                output[1] = 0.003352329869259135;
                break;
            }
            case 1: {
                output[0] = 6378140.0;
                output[1] = 0.0033528131778969143;
                break;
            }
            case 2: {
                output[0] = 6378137.0;
                output[1] = 0.003352810681182319;
            }
        }
        return output;
    }

    public static double[] GaussToBL(double X, double Y, int coordinateName, int mZoneWide) {
        double[] output = new double[2];
        double[] coordinateParam = GaussXY2BL.selectCoordinateParam(coordinateName);
        double iPI = 0.0174532925199433;
        int ZoneWide = mZoneWide;
        int ProjNo = (int)(X / 1000000.0);
        double longitude0 = ZoneWide == 3 ? (double)(ProjNo * 3) : (double)((ProjNo - 1) * ZoneWide + ZoneWide / 2);
        longitude0 *= iPI;
        double X0 = (long)ProjNo * 1000000L + 500000L;
        double Y0 = 0.0;
        double xval = X - X0;
        double yval = Y - Y0;
        double e2 = 2.0 * coordinateParam[1] - coordinateParam[1] * coordinateParam[1];
        double e1 = (1.0 - Math.sqrt(1.0 - e2)) / (1.0 + Math.sqrt(1.0 - e2));
        double ee = e2 / (1.0 - e2);
        double M = yval;
        double u = M / (coordinateParam[0] * (1.0 - e2 / 4.0 - 3.0 * e2 * e2 / 64.0 - 5.0 * e2 * e2 * e2 / 256.0));
        double fai = u + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * u) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * u) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * u) + 1097.0 * e1 * e1 * e1 * e1 / 512.0 * Math.sin(8.0 * u);
        double C = ee * Math.cos(fai) * Math.cos(fai);
        double T = Math.tan(fai) * Math.tan(fai);
        double NN = coordinateParam[0] / Math.sqrt(1.0 - e2 * Math.sin(fai) * Math.sin(fai));
        double R = coordinateParam[0] * (1.0 - e2) / Math.sqrt((1.0 - e2 * Math.sin(fai) * Math.sin(fai)) * (1.0 - e2 * Math.sin(fai) * Math.sin(fai)) * (1.0 - e2 * Math.sin(fai) * Math.sin(fai)));
        double D = xval / NN;
        double longitude1 = longitude0 + (D - (1.0 + 2.0 * T + C) * D * D * D / 6.0 + (5.0 - 2.0 * C + 28.0 * T - 3.0 * C * C + 8.0 * ee + 24.0 * T * T) * D * D * D * D * D / 120.0) / Math.cos(fai);
        double latitude1 = fai - NN * Math.tan(fai) / R * (D * D / 2.0 - (5.0 + 3.0 * T + 10.0 * C - 4.0 * C * C - 9.0 * ee) * D * D * D * D / 24.0 + (61.0 + 90.0 * T + 298.0 * C + 45.0 * T * T - 256.0 * ee - 3.0 * C * C) * D * D * D * D * D * D / 720.0);
        output[0] = longitude1 / iPI;
        output[1] = latitude1 / iPI;
        return output;
    }

    public static double[] BLToGauss(double longitude, double latitude, int coordinateName) {
        int ProjNo = 0;
        double[] output = new double[2];
        double[] coordinateParam = GaussXY2BL.selectCoordinateParam(coordinateName);
        double iPI = 0.0174532925199433;
        int ZoneWide = 6;
        ProjNo = (int)(longitude / (double)ZoneWide);
        double longitude0 = ProjNo * ZoneWide + ZoneWide / 2;
        longitude0 *= iPI;
        double longitude1 = longitude * iPI;
        double latitude1 = latitude * iPI;
        double e2 = 2.0 * coordinateParam[1] - coordinateParam[1] * coordinateParam[1];
        double ee = e2 * (1.0 - e2);
        double NN = coordinateParam[0] / Math.sqrt(1.0 - e2 * Math.sin(latitude1) * Math.sin(latitude1));
        double T = Math.tan(latitude1) * Math.tan(latitude1);
        double C = ee * Math.cos(latitude1) * Math.cos(latitude1);
        double A = (longitude1 - longitude0) * Math.cos(latitude1);
        double M = coordinateParam[0] * ((1.0 - e2 / 4.0 - 3.0 * e2 * e2 / 64.0 - 5.0 * e2 * e2 * e2 / 256.0) * latitude1 - (3.0 * e2 / 8.0 + 3.0 * e2 * e2 / 32.0 + 45.0 * e2 * e2 * e2 / 1024.0) * Math.sin(2.0 * latitude1) + (15.0 * e2 * e2 / 256.0 + 45.0 * e2 * e2 * e2 / 1024.0) * Math.sin(4.0 * latitude1) - 35.0 * e2 * e2 * e2 / 3072.0 * Math.sin(6.0 * latitude1));
        double xval = NN * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * ee) * A * A * A * A * A / 120.0);
        double yval = M + NN * Math.tan(latitude1) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * ee) * A * A * A * A * A * A / 720.0);
        double X0 = 1000000L * (long)(ProjNo + 1) + 500000L;
        double Y0 = 0.0;
        output[0] = xval += X0;
        output[1] = yval += Y0;
        return output;
    }

    public static void main(String[] args) {
        double[] BL;
        for (double a : BL = GaussXY2BL.GaussToBL(3.94661344265137E7, 3544468.3939209, Xian80, 3)) {
            System.err.println(a);
        }
    }
}

