/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.base.util;

import com.geoway.ns.base.enums.ShapeType;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;

public class GeometryUtils {
    public static final Integer GEOMETRY_SRID = 4490;
    private static final String projectiveCoordinateSystems = "PROJCS[\"CGCS2000_3_Degree_GK_Zone_%d\",GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",%d500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",%d],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0]]";
    private static final String cgcsGeo = "GEOGCS[\"GCS_CGCS_2000\",DATUM[\"D_GCS_CGCS_2000\",SPHEROID[\"D_China_2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]]";
    public static final Double DEFAULT_BUFFER = 2.697963123853744E-5;

    public static Geometry wktToGeometry(String wkt, Integer spatialReferenceSystemId) throws ParseException {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)wkt), (String)"\u53c2\u6570wkt\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String[] sections = wkt.split(";");
        String coordinates = sections.length > 1 ? sections[sections.length - 1] : wkt;
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(coordinates);
        geometry.setSRID((spatialReferenceSystemId == null ? GEOMETRY_SRID : spatialReferenceSystemId).intValue());
        return geometry;
    }

    public static Geometry wktToGeometry(String wkt) throws Exception {
        WKTReader reader = new WKTReader();
        return reader.read(wkt);
    }

    public static String geometryToWkt(Geometry geometry) {
        WKTWriter writer = new WKTWriter();
        return writer.write(geometry);
    }

    public static Geometry bufferGeometry(Geometry geometry, int buffer) throws Exception {
        if (geometry == null || geometry.getCentroid() == null) {
            throw new IllegalArgumentException("geometry\u5bf9\u8c61\u6216\u4e2d\u5fc3\u70b9\u4e3a\u7a7a");
        }
        CoordinateReferenceSystem destCRS = GeometryUtils.findTargetProjectiveCRS(geometry.getCentroid().getX());
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        Geometry newGeo = JTS.transform((Geometry)geometry, (MathTransform)transform);
        newGeo = newGeo.buffer((double)buffer);
        transform = CRS.findMathTransform((CoordinateReferenceSystem)destCRS, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        newGeo = JTS.transform((Geometry)newGeo, (MathTransform)transform);
        return newGeo;
    }

    public static int getProjectiveNoByLongitude(Double longitude) {
        if (longitude == null) {
            throw new IllegalArgumentException("\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (int)((longitude - 1.5) / 3.0) + 1;
    }

    public static CoordinateReferenceSystem findTargetProjectiveCRS(Double longitude) throws FactoryException {
        int projectionNo = GeometryUtils.getProjectiveNoByLongitude(longitude);
        if (projectionNo > 60) {
            return null;
        }
        String wkt = String.format(projectiveCoordinateSystems, projectionNo, projectionNo, projectionNo * 3);
        return CRS.parseWKT((String)wkt);
    }

    public static ShapeType getShapeTypeByWkt(String wkt) {
        if (StringUtils.isBlank((CharSequence)wkt)) {
            return null;
        }
        String type = wkt.substring(0, wkt.indexOf("(")).trim();
        switch (type.toUpperCase()) {
            case "POINT": {
                return ShapeType.POINT;
            }
            case "LINESTRING": {
                return ShapeType.LINE_STRING;
            }
            case "MULTILINESTRING": {
                return ShapeType.MULTI_LINE_STRING;
            }
            case "POLYGON": {
                return ShapeType.POLYGON;
            }
            case "MULTIPOLYGON": {
                return ShapeType.MULTI_POLYGON;
            }
        }
        return null;
    }

    public static Geometry transform(Geometry geometry) throws FactoryException, TransformException {
        if (geometry == null || geometry.getCentroid() == null) {
            throw new IllegalArgumentException("geometry\u5bf9\u8c61\u6216\u4e2d\u5fc3\u70b9\u4e3a\u7a7a");
        }
        CoordinateReferenceSystem destCRS = GeometryUtils.findTargetProjectiveCRS(geometry.getCentroid().getX());
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)destCRS, (boolean)true);
        return JTS.transform((Geometry)geometry, (MathTransform)transform);
    }

    public static Geometry transform(Geometry geom, int sourceSRID, int targetSRID) throws Exception {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)("EPSG:" + sourceSRID));
        CoordinateReferenceSystem targetCRS = CRS.decode((String)("EPSG:" + targetSRID));
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        return JTS.transform((Geometry)geom, (MathTransform)transform);
    }

    public static Double calcOverlayRate(Geometry geometry1, Geometry geometry2) {
        Geometry intersection = geometry1.intersection(geometry2);
        if (intersection != null) {
            return intersection.getArea() / geometry1.getArea();
        }
        return null;
    }

    public static CoordinateReferenceSystem getCGCS200CRS() throws FactoryException {
        return CRS.parseWKT((String)cgcsGeo);
    }

    public static void writeShape(String shpPath, String encode, String geoType, String shpKey, List<String> attrKeys, List<Map<String, Object>> data) throws Exception {
        if (StringUtils.isEmpty((CharSequence)encode)) {
            encode = Charset.defaultCharset().toString();
        }
        if (StringUtils.isEmpty((CharSequence)geoType)) {
            geoType = "MultiPolygon";
        }
        if (StringUtils.isEmpty((CharSequence)shpKey)) {
            shpKey = "wkt";
        }
        for (String key : attrKeys) {
            if (key.length() <= 10) continue;
            throw new RuntimeException("\u5b57\u6bb5\u3010" + key + "\u3011\u957f\u5ea6\u8d85\u8fc710\u4f4d\uff01");
        }
        attrKeys.remove(shpKey);
        if (data == null || data.size() == 0) {
            return;
        }
        File file = new File(shpPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
        ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setCRS(GeometryUtils.getCGCS200CRS());
        tb.setName("shapefile");
        tb = GeometryUtils.createType(tb, geoType);
        for (String field : attrKeys) {
            tb.add(field.toUpperCase(), String.class);
        }
        ds.createSchema(tb.buildFeatureType());
        Charset charset = Charset.forName(encode);
        ds.setCharset(charset);
        FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
        try {
            for (Map<String, Object> map : data) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                feature.setAttribute("the_geom", (Object)GeometryUtils.wktToGeometry((String)map.get(shpKey), GEOMETRY_SRID));
                for (String key : attrKeys) {
                    Object o = map.get(key);
                    feature.setAttribute(key.toUpperCase(), o);
                }
            }
            writer.write();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            writer.close();
            ds.dispose();
        }
    }

    private static SimpleFeatureTypeBuilder createType(SimpleFeatureTypeBuilder tb, String type) throws Exception {
        if ("Polygon".equalsIgnoreCase(type)) {
            tb.add("the_geom", Polygon.class);
        } else if ("MultiPolygon".equalsIgnoreCase(type)) {
            tb.add("the_geom", MultiPolygon.class);
        } else if ("Point".equalsIgnoreCase(type)) {
            tb.add("the_geom", Point.class);
        } else if ("MultiPoint".equalsIgnoreCase(type)) {
            tb.add("the_geom", MultiPoint.class);
        } else if ("LineString".equalsIgnoreCase(type)) {
            tb.add("the_geom", LineString.class);
        } else if ("MultiLineString".equalsIgnoreCase(type)) {
            tb.add("the_geom", MultiLineString.class);
        } else {
            throw new Exception("Geometry\u4e2d\u6ca1\u6709\u8be5\u7c7b\u578b\uff1a" + type);
        }
        return tb;
    }
}

