/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.dto.TbAnalysisYZFXDetail;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3GrantService;
import com.geoway.ns.geoserver3.service.IYZFXService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class YZFXServiceImpl
implements IYZFXService {
    private static final Logger log = LoggerFactory.getLogger(YZFXServiceImpl.class);
    private String RequestMapping = "/rest/manage/yzfx";
    private String analysisMapping = "/rest/yzfx";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private IGeoserver3GrantService geoserver3GrantService;

    @Override
    public boolean checkIsExist(String serviceName) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/checkIsExist?serviceName=" + serviceName;
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return false;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            return responseObj.getBoolean("Results");
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisYZFXDetail findById(String serviceId) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findDetail?id=" + serviceId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisYZFXDetail)JSON.parseObject((String)resultStr, TbAnalysisYZFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisYZFXDetail findById(String serverRootUrl, String serviceId, String accessKey) {
        String findUrl = serverRootUrl + this.RequestMapping + "/findDetail?id=" + serviceId;
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisYZFXDetail)JSON.parseObject((String)resultStr, TbAnalysisYZFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisYZFXDetail findByName(String serviceName) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findDetailByName?serviceName=" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisYZFXDetail)JSON.parseObject((String)resultStr, TbAnalysisYZFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisYZFXDetail save(TbAnalysisYZFXDetail yzfxDetail) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String saveUrl = url + this.RequestMapping + "/save";
        String paramMapStr = JSON.toJSONString((Object)yzfxDetail);
        String responseStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            TbAnalysisYZFXDetail detail = (TbAnalysisYZFXDetail)JSON.parseObject((String)resultStr, TbAnalysisYZFXDetail.class);
            this.geoserver3GrantService.grantedById(this.geoserver3ConfigService.getApplicationGuid(), detail.getId());
            return detail;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public boolean delete(String serviceId) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/delete?id=" + serviceId;
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return false;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            return true;
        }
        log.error(responseObj.getString("Message"));
        return false;
    }

    @Override
    public Object findCustoms() {
        String url = this.geoserver3ConfigService.getUrl();
        String saveUrl = url + this.RequestMapping + "/findCustoms";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            return responseObj.get((Object)"Results");
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public ServiceMetadataDAO metadata(String name) {
        String url = this.geoserver3ConfigService.getUrl();
        String saveUrl = url + "/rest/yzfx/" + name + "/metadata";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (ServiceMetadataDAO)JSON.parseObject((String)resultStr, ServiceMetadataDAO.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public ServiceMetadataDAO metadata(String serverUrl, String ApplicationGUID, String accessKey) {
        String responseStr;
        String saveUrl = serverUrl + "/metadata";
        if (serverUrl.indexOf("?") > -1) {
            saveUrl = serverUrl.split("?")[0] + "/metadata?" + serverUrl.split("?")[1];
        }
        if (StringUtils.isEmpty((CharSequence)(responseStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).execute().body()))) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (ServiceMetadataDAO)JSON.parseObject((String)resultStr, ServiceMetadataDAO.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public JSONObject analysis(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject analysis(String serverUrl, Map<String, Object> param, String ApplicationGUID, String accessKey) {
        if (StringUtils.isNotEmpty((CharSequence)ApplicationGUID)) {
            param.put("ApplicationGUID", ApplicationGUID);
        }
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject getCoverInfo(String uniqueTaskId) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/getCoverInfo?uniqueTaskId=" + uniqueTaskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject getCoverInfo(String serverUrl, String uniqueTaskId, String ApplicationGUID, String accessKey) {
        String responseStr;
        if (StringUtils.isEmpty((CharSequence)serverUrl)) {
            return null;
        }
        String url = serverUrl;
        String queryParam = "";
        if (serverUrl.indexOf("?") > -1) {
            String[] urlParams = serverUrl.split("?");
            url = urlParams[0];
            queryParam = urlParams[1];
        }
        String _serverUrl = url.substring(0, url.lastIndexOf(47)) + "/getCoverInfo?uniqueTaskId=" + uniqueTaskId;
        if (StringUtils.isNotEmpty((CharSequence)queryParam)) {
            _serverUrl = _serverUrl + "&" + queryParam;
        }
        if (StringUtils.isEmpty((CharSequence)(responseStr = ((HttpRequest)HttpRequest.get((String)_serverUrl).header("access-token", accessKey)).execute().body()))) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject statByResult(String serviceName, String analysisResult) {
        this.geoserver3ConfigService.check();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AnalysisID", UUID.randomUUID().toString());
        params.put("analysisResult", (String)JSONArray.parseArray((String)analysisResult));
        params.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName + "/StatByResult";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(params);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public List<TbAnalysisBaseInfo> findAll() {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findAll";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (List)JSON.parseObject((String)resultStr, (TypeReference)new TypeReference<List<TbAnalysisBaseInfo>>(){}, (Feature[])new Feature[0]);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public List<TbAnalysisBaseInfo> findAll(String serverRootUrl, String accessKey) {
        String findUrl = serverRootUrl + this.RequestMapping + "/findAll";
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (List)JSON.parseObject((String)resultStr, (TypeReference)new TypeReference<List<TbAnalysisBaseInfo>>(){}, (Feature[])new Feature[0]);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }
}

