/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3FzxzService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Geoserver3FzxzServiceImpl
implements IGeoserver3FzxzService {
    private String RequestMapping = "/rest/manage/fzxz";
    private String analysisMapping = "/rest/fzxz";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;

    @Override
    public List<TbAnalysisBaseInfo> findList() {
        return this.tbAnalysisBaseInfoService.findByType("fzxz");
    }

    @Override
    public JSONObject findDetailById(String id) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findDetail?id=" + id;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseObject((String)resultStr);
        }
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public JSONObject findDetailByName(String name) {
        HttpRequest http = this.createHttp(Method.GET, this.analysisMapping + "/" + name + "/info");
        return this.getRes(http.execute()).getJSONObject("Results");
    }

    @Override
    public JSONObject analysis(String fzxzServiceId, Map<String, Object> param) {
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        TbAnalysisBaseInfo tbAnalysisBaseInfo = this.tbAnalysisBaseInfoService.findById(fzxzServiceId);
        if (tbAnalysisBaseInfo == null) {
            throw new RuntimeException("\u7ed1\u5b9a\u7684\u8f85\u52a9\u9009\u5740\u670d\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        return this.analysisByName(tbAnalysisBaseInfo.getName(), param);
    }

    @Override
    public JSONObject analysisByName(String serviceName, Map<String, Object> param) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        HttpResponse execute = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute();
        return this.getRes(execute);
    }

    @Override
    public JSONArray queryLandType(String id) {
        this.geoserver3ConfigService.check();
        HttpRequest http = this.createHttp(Method.GET, this.RequestMapping + "/queryLandType");
        http.form("id", (Object)id);
        return this.getResArray(http.execute());
    }

    @Override
    public JSONObject report(String serviceId) {
        HttpRequest http = this.createHttp(Method.GET, "/rest/report/findResportBySceneServiceId");
        http.form("scheneServiceId", (Object)serviceId);
        return this.getRes(http.execute()).getJSONObject("Results");
    }

    private HttpRequest createHttp(Method method, String path) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl() + path;
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)url);
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        request.header("access-token", accessKey);
        return request;
    }

    private JSONObject getRes(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("Message"));
        }
        return object;
    }

    private JSONArray getResArray(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("Message"));
        }
        return object.getJSONArray("Results");
    }
}

