/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.UpdateToolDTO;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3UpdateToolService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Geoserver3UpdateToolServiceImpl
implements IGeoserver3UpdateToolService {
    private static final Logger log = LoggerFactory.getLogger(Geoserver3UpdateToolServiceImpl.class);
    private String RequestMapping = "/rest/updatetool";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @Override
    public List<UpdateToolDTO.UpdateRecordSimple> recordList(String serviceId) throws Exception {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/updateRecord/list?serviceId=" + serviceId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            List list = JSON.parseArray((String)resultStr, UpdateToolDTO.UpdateRecordSimple.class);
            return list;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public UpdateToolDTO.UpdateRecordDetail contentDetail(String uniqueTaskId, String contentField) throws Exception {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/updateRecord/detail?uniqueTaskId=" + uniqueTaskId + "&contentField=" + contentField;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            UpdateToolDTO.UpdateRecordDetail detail = (UpdateToolDTO.UpdateRecordDetail)JSON.parseObject((String)resultStr, UpdateToolDTO.UpdateRecordDetail.class);
            return detail;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }
}

