/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskLog;
import com.geoway.ns.geoserver3.service.IFlowService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowServiceImpl
implements IFlowService {
    private static final Logger log = LoggerFactory.getLogger(FlowServiceImpl.class);
    private String RequestMapping = "/rest/manage/busimodel";
    private String analysisMapping = "/rest/flow";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private ITbAnalysisBaseInfoService tbAnalysisBaseInfoService;
    @Autowired
    private IGeoserver3TaskService geoserver3TaskService;

    @Override
    public boolean checkIsExist(String serviceName) {
        return false;
    }

    @Override
    public ServiceMetadataDAO metadata(String serviceName) {
        return this.tbAnalysisBaseInfoService.metadata("flow", serviceName);
    }

    @Override
    public List<TbAnalysisTaskLog> logs(String uniqueTaskId) throws Exception {
        String version = this.geoserver3ConfigService.getVersion();
        Double dVersion = Double.parseDouble(version);
        List<TbAnalysisTaskLog> taskLogs = null;
        taskLogs = dVersion < 3.1 ? this.findOldLogs(uniqueTaskId) : this.geoserver3TaskService.findTaskLog(uniqueTaskId);
        return taskLogs;
    }

    @Override
    public List<TbAnalysisTask> taskList(List<String> uniqueTaskIds) {
        String version = this.geoserver3ConfigService.getVersion();
        Double dVersion = Double.parseDouble(version);
        List<TbAnalysisTask> tasks = null;
        tasks = dVersion < 3.1 ? this.findOldTasks(uniqueTaskIds) : this.geoserver3TaskService.findTaskByIds(uniqueTaskIds);
        return tasks;
    }

    @Override
    public TbAnalysisTask task(String uniqueTaskId) {
        String version = this.geoserver3ConfigService.getVersion();
        Double dVersion = Double.parseDouble(version);
        TbAnalysisTask task = null;
        task = dVersion < 3.1 ? this.findOldTask(uniqueTaskId) : this.geoserver3TaskService.findTaskById(uniqueTaskId);
        return task;
    }

    @Override
    public String analysis(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(500)) {
            throw new RuntimeException(responseObj.getString("Message"));
        }
        return responseObj.getString("UniqueTaskID");
    }

    private List<TbAnalysisTaskLog> findOldLogs(String uniqueTaskId) {
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/logs?uniqueTaskId=" + uniqueTaskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisTaskLog.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    private List<TbAnalysisTask> findOldTasks(List<String> uniqueTaskIds) {
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/taskList?uniqueTaskIds=" + StringUtils.join(uniqueTaskIds, (String)",");
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisTask.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    private TbAnalysisTask findOldTask(String uniqueTaskId) {
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/task?uniqueTaskId=" + uniqueTaskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisTask)JSON.parseObject((String)resultStr, TbAnalysisTask.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }
}

