/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.service.IDTSPService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3GrantService;
import com.geoway.ns.sys.utils.FileUploadUtil;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DTSPServiceImpl
implements IDTSPService {
    private static final Logger log = LoggerFactory.getLogger(DTSPServiceImpl.class);
    private String AnalysisMapping = "/rest/dtsp";
    private String ManageMapping = "/rest/manage/dtsp";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private IGeoserver3GrantService geoserver3GrantService;
    @Autowired
    private FileUploadUtil fileUploadUtil;

    @Override
    public JSONObject findByName(String serviceName) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/findByName?name=" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)url).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject findById(String id) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/dtsp/findById?id=" + id;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)url).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject findStatusByTaskId(String taskId) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/result/findStatusByTaskId";
        String body = HttpUtil.createGet((String)url).form("id", (Object)taskId).execute().body();
        JSONObject object = JSON.parseObject((String)body);
        return object;
    }

    @Override
    public JSONObject findResultById(String id) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/result/findOneById";
        String body = HttpUtil.createGet((String)url).form("id", (Object)id).execute().body();
        JSONObject object = JSON.parseObject((String)body);
        return object;
    }

    @Override
    public JSONArray findResultByTaskId(String taskId) {
        HttpRequest get = this.createHttp(Method.GET, "/rest/dtsp/result/findResultByTaskId");
        HttpResponse execute = get.form("id", (Object)taskId).execute();
        JSONObject result = this.getRes(execute);
        return result.getJSONArray("Results");
    }

    @Override
    public JSONObject findResulByServiceId(String id, String serviceId) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/result/findByServiceId";
        String body = HttpUtil.createGet((String)url).form("id", (Object)id).form("serviceId", (Object)serviceId).execute().body();
        JSONObject object = JSON.parseObject((String)body);
        return object;
    }

    @Override
    public JSONObject findRuleResultByTaskId(String taskId, String dtspId) {
        String geoserverURL = this.geoserver3ConfigService.getUrl();
        String url = geoserverURL + this.AnalysisMapping + "/result/rule/findResultByTaskId";
        String body = HttpUtil.createGet((String)url).form("id", (Object)taskId).form("dtspId", (Object)dtspId).execute().body();
        System.out.println("url\uff1a" + url);
        System.out.println("findResultByTaskId\uff1a" + body);
        JSONObject object = JSON.parseObject((String)body);
        return object;
    }

    @Override
    public JSONObject analysisExtention(Map<String, Object> param, String serviceName) {
        return this.analysis(param, serviceName, "/extension");
    }

    @Override
    public JSONObject resetAnalysisExtention(String serviceName, String taskId, String serviceId) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.AnalysisMapping + "/" + serviceName + "/extension/reset";
        String responseStr = HttpRequest.post((String)serverUrl).form("taskId", (Object)taskId).form("serviceId", (Object)serviceId).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject analysisRule(Map<String, Object> param, String serviceName) {
        return this.analysis(param, serviceName, "/rule");
    }

    @Override
    public JSONObject queryRules(String serviceName) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + "/rest/rule/getRules";
        String responseStr = HttpRequest.post((String)serverUrl).form("serviceName", (Object)serviceName).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject findImageByServiceId(String taskId, String serviceId) {
        this.geoserver3ConfigService.check();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.AnalysisMapping + "/result/findImageByServiceId";
        String responseStr = HttpRequest.get((String)serverUrl).form("id", (Object)taskId).form("serviceId", (Object)serviceId).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONArray findList() {
        HttpRequest http = this.createHttp(Method.GET, this.AnalysisMapping + "/findAll");
        JSONObject res = this.getRes(http.execute());
        return res.getJSONArray("Results");
    }

    @Override
    public JSONObject uploadXm(MultipartFile file) {
        HttpRequest http = this.createHttp(Method.POST, "/rest/analysis/upload");
        String path = System.getProperty("user.dir");
        String tempPath = path + File.separator + file.getOriginalFilename();
        try {
            File tempFile = new File(tempPath);
            file.transferTo(tempFile);
            http.form("fileData", tempFile);
            String body = http.execute().body();
            JSONObject jSONObject = JSON.parseObject((String)body);
            return jSONObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        finally {
            FileUtil.del((String)tempPath);
        }
    }

    @Override
    public JSONObject findReport(String dtspId) {
        HttpRequest http = this.createHttp(Method.GET, "/rest/report/findResportBySceneServiceId");
        http.form("scheneServiceId", (Object)dtspId);
        return this.getRes(http.execute()).getJSONObject("Results");
    }

    @Override
    public void exportReport(HttpServletResponse response, String taskId) {
        HttpRequest http = this.createHttp(Method.POST, "/rest/report/exportByTaskId");
        http.form("taskId", (Object)taskId);
        HttpResponse execute = http.execute();
        String type = execute.header("Content-Type");
        if (type.equals("application/json")) {
            this.getRes(execute);
        } else {
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (InputStream)execute.bodyStream(), (Map)execute.headers());
        }
    }

    @Override
    public JSONArray findRuleRes(String service, String type, Boolean status, String id, Integer verify) {
        HttpRequest get = this.createHttp(Method.GET, "/rest/dtsp/result/rule/" + service + "/findDetail");
        HttpResponse execute = get.form("type", (Object)type).form("status", (Object)status).form("id", (Object)id).form("verify", (Object)verify).execute();
        return this.getRes(execute).getJSONArray("Results");
    }

    private HttpRequest createHttp(Method method, String path) {
        String url = this.geoserver3ConfigService.getUrl() + path;
        return HttpUtil.createRequest((Method)method, (String)url);
    }

    private JSONObject getRes(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("Message"));
        }
        return object;
    }

    private JSONObject analysis(Map<String, Object> param, String serviceName, String extraRequest) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.AnalysisMapping + "/" + serviceName;
        if (!StringUtils.isEmpty((CharSequence)extraRequest)) {
            serverUrl = serverUrl + extraRequest;
        }
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }
}

