/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.geoserver3.dto.BaseResponseData;
import com.geoway.ns.geoserver3.dto.DatabaseDTO;
import com.geoway.ns.geoserver3.service.IDatabaseService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatabaseServiceImpl
implements IDatabaseService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseServiceImpl.class);
    private String RequestMapping = "/rest/manage/dbManager";
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @Override
    public boolean addDatabase(String adfDbKey) {
        if (!this.useSeparateDatasource()) {
            System.out.println("\u5206\u6790\u5f15\u64ce\u672a\u4f7f\u7528\u72ec\u7acb\u6570\u636e\u6e90\uff0c\u65e0\u9700\u540c\u6b65adf\u6570\u636e\u6e90");
            return true;
        }
        DataSourceDTO dataSourceDTO = this.dataSourceService.getDataSourceDetail(adfDbKey);
        return this.addDatabase(dataSourceDTO);
    }

    private boolean addDatabase(DataSourceDTO dataSourceDTO) {
        DatabaseDTO toSavedDatabase = this.getDatabaseDTO(dataSourceDTO.getKey());
        if (toSavedDatabase == null) {
            toSavedDatabase = new DatabaseDTO();
        }
        toSavedDatabase.setName("\u4e00\u5f20\u56fe_" + dataSourceDTO.getName());
        toSavedDatabase.setKey(dataSourceDTO.getKey());
        toSavedDatabase.setDbtype(dataSourceDTO.getDataStoreType());
        if (dataSourceDTO.getDataSourceType().equals(0)) {
            toSavedDatabase.setSdbtype(3);
        } else if (dataSourceDTO.getDataSourceType().equals(1)) {
            toSavedDatabase.setSdbtype(22);
        } else if (dataSourceDTO.getDataSourceType().equals(2)) {
            toSavedDatabase.setSdbtype(10);
        } else if (dataSourceDTO.getDataSourceType().equals(3) || dataSourceDTO.getDataSourceType().equals(4)) {
            toSavedDatabase.setSdbtype(20);
        } else {
            toSavedDatabase.setSdbtype(-1);
        }
        DatabaseDTO.ConnectInfo connectInfo = new DatabaseDTO.ConnectInfo();
        String dbUrl = dataSourceDTO.getUrl();
        String[] dbUrlSplits = dbUrl.split("/");
        connectInfo.setDbName(dbUrlSplits[1]);
        String[] ipAndPort = dbUrlSplits[0].split(":");
        connectInfo.setIp(ipAndPort[0]);
        connectInfo.setPort(ipAndPort[1]);
        connectInfo.setUsername(dataSourceDTO.getUserName());
        connectInfo.setPassword(dataSourceDTO.getPassword());
        toSavedDatabase.setConnectInfo(connectInfo);
        return this.saveDatabase(toSavedDatabase);
    }

    private boolean useSeparateDatasource() {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/useSeparateDatasource";
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return true;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj.getBoolean("Results");
    }

    private DatabaseDTO getDatabaseDTO(String dbKey) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/findDatabaseByKey?key=" + dbKey + "&hidePwd=false";
        String responseStr = ((HttpRequest)HttpRequest.post((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (DatabaseDTO)JSON.parseObject((String)resultStr, DatabaseDTO.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    private boolean saveDatabase(DatabaseDTO databaseDTO) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String saveUrl = url + this.RequestMapping + "/saveDatabase";
        String paramMapStr = com.alibaba.fastjson.JSON.toJSONString((Object)databaseDTO);
        String resultStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            return false;
        }
        BaseResponseData responseData = (BaseResponseData)JSON.parseObject((String)resultStr, BaseResponseData.class);
        if (responseData.get("StatusCode").equals(200) || responseData.get("Message").equals("\u5df2\u5b58\u5728\u540c\u540d\u6570\u636e\u5e93")) {
            return true;
        }
        log.error((String)responseData.get("Message"));
        throw new RuntimeException((String)responseData.get("Message"));
    }
}

