/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.InverseGeocodingVO;
import com.geoway.ns.geoserver3.service.IGeoToolService;
import com.geoway.ns.geoserver3.service.impl.AbstractGeoServer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class GeoToolServiceImpl
extends AbstractGeoServer
implements IGeoToolService {
    @Override
    public Double queryProjectArea(List<String> wkts) {
        String url = String.format("%s/rest/tools/projectArea", this.geoserver3ConfigService.getUrl());
        HttpRequest post = HttpUtil.createPost((String)url);
        final List blocks = wkts.stream().map(m -> {
            JSONObject object = new JSONObject();
            object.put("DK_ID", (Object)UUID.randomUUID().toString());
            object.put("WKID", (Object)"4490");
            object.put("WKT", m);
            return object;
        }).collect(Collectors.toList());
        String body = JSONObject.toJSONString((Object)new HashMap<String, Object>(){
            {
                this.put("Blocks", blocks);
                this.put("applicationGUID", GeoToolServiceImpl.this.geoserver3ConfigService.getApplicationGuid());
            }
        });
        post.body(body);
        JSONArray resArray = this.getResArray(post.execute());
        BigDecimal decimal = new BigDecimal(0.0);
        for (JSONObject object : resArray.toJavaList(JSONObject.class)) {
            BigDecimal dkMj = object.getBigDecimal("DK_MJ");
            decimal = decimal.add(dkMj).setScale(4, 1);
        }
        return decimal.doubleValue();
    }

    @Override
    public List<InverseGeocodingVO> inverseGeoCoding(String location, String point) {
        try {
            String url = String.format("%s/rest/tools/inverseGeocoding", this.geoserver3ConfigService.getUrl());
            HttpRequest get = HttpUtil.createGet((String)url);
            get.form("location", (Object)location);
            get.form("pointWkt", (Object)point);
            JSONArray resArray = this.getResArray(get.execute());
            return resArray.toJavaList(InverseGeocodingVO.class);
        }
        catch (Exception e) {
            return new ArrayList<InverseGeocodingVO>();
        }
    }
}

