/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.govt.controller;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.ns.govt.entity.SysNews;
import com.geoway.ns.govt.service.SysNewsService;
import com.geoway.ns.sys.dto.BaseResponse;
import com.geoway.ns.sys.dto.DataResponse;
import com.geoway.ns.sys.dto.EasyUIResponse;
import com.geoway.ns.sys.dto.FileDownloadMeta;
import com.geoway.ns.sys.dto.FileServerResponse;
import com.geoway.ns.sys.dto.FileUploadResponse;
import com.geoway.ns.sys.dto.SysUserDTO;
import com.geoway.ns.sys.service.FileServerService;
import com.geoway.ns.sys.service.ITokenService;
import com.geoway.ns.sys.utils.FileUploadUtil;
import com.geoway.ns.sys.utils.MyRequestUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u65b0\u95fb\u901a\u77e5"})
@RequestMapping(value={"/sysNews"})
public class SysNewsController {
    @Resource
    private SysNewsService sysNewsService;
    @Resource
    private ITokenService iTokenService;
    @Autowired
    FileServerService fileServerService;
    @Autowired
    FileUploadUtil fileUploadUtil;

    @ApiOperation(value="1-\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"/addSysNews"}, produces={"application/json"})
    public BaseResponse addSysNews(HttpServletRequest request, @ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            SysUserDTO sysUser = this.iTokenService.querySysUserByToken(MyRequestUtil.queryAccessTokenInHeader((HttpServletRequest)request), Boolean.valueOf(true));
            sysNews.setCreater(sysUser.getUsername());
            this.sysNewsService.addSysNews(sysNews);
            response.setResult((Object)sysNews);
            response.setShowData(true);
            response.setMessage("\u65b0\u589e\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="2-\u5220\u9664\u6570\u636e")
    @PostMapping(value={"/deleteSysNews"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse deleteSysNews(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.deleteSysNews(sysNews);
            response.setResult((Object)"\u5220\u9664\u6570\u636e\u6210\u529f\uff01");
            response.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="3-\u4fee\u6539\u76ee\u5f55")
    @PostMapping(value={"/updateSysNews"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse updateSysNews(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.updateSysNews(sysNews);
            response.setResult((Object)sysNews);
            response.setShowData(true);
            response.setMessage("\u66f4\u65b0\u6570\u636e\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="4-\u5206\u9875\u67e5\u8be2\u76ee\u5f55")
    @GetMapping(value={"/querySysNews"}, produces={"application/json;charset=UTF-8"})
    public EasyUIResponse querySysNews(@ModelAttribute SysNews sysNews) {
        EasyUIResponse response = new EasyUIResponse();
        try {
            IPage<SysNews> sysNewsPageData = this.sysNewsService.querySysNews(sysNews);
            response.setRows(sysNewsPageData.getRecords());
            response.setTotal(Long.valueOf(sysNewsPageData.getTotal()));
        }
        catch (Exception e) {
            return EasyUIResponse.buildFailuaResponse((Exception)e);
        }
        return response;
    }

    @ApiOperation(value="5-\u67e5\u8be2\u76ee\u5f55\u6811")
    @GetMapping(value={"/querySysNewsTree"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse querySysNewsTree(@ModelAttribute SysNews sysNews) {
        DataResponse response = new DataResponse();
        try {
            List<Tree<String>> sysNewsTree = this.sysNewsService.querySysNewsTree(sysNews);
            response.setResult(sysNewsTree);
            response.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return response;
    }

    @ApiOperation(value="6-\u5bf9\u6570\u636e\u8fdb\u884c\u6392\u5e8f")
    @PostMapping(value={"sortSysNews"}, produces={"application/json;charset=UTF-8"})
    public BaseResponse sortSysNews(@RequestParam(value="id") String id, @RequestParam(value="sortType") Integer sortType) {
        DataResponse response = new DataResponse();
        try {
            this.sysNewsService.sortSysNews(id, sortType);
            response.setResult((Object)"\u6570\u636e\u6392\u5e8f\u64cd\u4f5c\u6210\u529f");
            response.setShowData(true);
        }
        catch (Exception ex) {
            return BaseResponse.error((Exception)ex);
        }
        return response;
    }

    @ApiOperation(value="7-\u65b0\u589e\u9644\u4ef6")
    @PostMapping(value={"/addSysNewsFile"})
    public Map<String, Object> addSysNewsFile(@RequestParam(value="fmFileData") MultipartFile file, @ModelAttribute SysNews sysNews) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("status", "OK");
        map.put("message", "\u65b0\u589e\u6587\u4ef6\u6210\u529f");
        try {
            if (StrUtil.isBlank((CharSequence)sysNews.getId()) || StrUtil.isBlank((CharSequence)sysNews.getUploadFileName())) {
                throw new IllegalAccessException("\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            JSONArray fileArray = this.sysNewsService.addSysNewsFile(file, sysNews);
            map.put("newsInfo", fileArray.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("status", "FAILURE");
            map.put("message", "\u65b0\u589e\u6587\u4ef6\u5931\u8d25!\u539f\u56e0\u662f:" + e.getMessage());
        }
        return map;
    }

    @ApiOperation(value="8-\u4e0a\u4f20\u9644\u4ef6")
    @PostMapping(value={"/uploadSysNewsFile"})
    public BaseResponse uploadSysNewsFile(@RequestParam(value="file") MultipartFile file) {
        DataResponse baseObjectResponse = new DataResponse();
        try {
            FileServerResponse fileServerResponse = this.fileServerService.sendFileToServerOnSpeFolder(file, "news");
            FileUploadResponse fileUploadResponse = fileServerResponse.convertToFileUploadResponse();
            baseObjectResponse.setResult((Object)fileUploadResponse);
            baseObjectResponse.setShowData(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
        return baseObjectResponse;
    }

    @ApiOperation(value="9-\u4e0b\u8f7d\u9644\u4ef6")
    @GetMapping(value={"/downloadSysNewsFile"})
    public void downloadSysNewsFile(@RequestParam(value="absolutePath") String absolutePath, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        try {
            if (StrUtil.isBlank((CharSequence)absolutePath)) {
                throw new Exception("\u53c2\u6570" + absolutePath + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String[] paths = absolutePath.split("@");
            String objectName = paths[0];
            if (paths.length > 1) {
                objectName = paths[1];
            }
            FileDownloadMeta fileDownloadMeta = this.fileServerService.queryDownLoadMeta(objectName);
            if (!fileName.contains(".")) {
                fileName = fileName + absolutePath.substring(absolutePath.lastIndexOf("."));
            }
            long fileSize = fileDownloadMeta.getFileSize();
            this.fileUploadUtil.downloadInputStream2Browser(response, fileDownloadMeta.getInputStream(), fileName, fileSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ApiOperation(value="10-\u5220\u9664\u9644\u4ef6")
    @PostMapping(value={"/deleteSysNewsFile"})
    public Map<String, Object> deleteSysNewsFile(@RequestParam(value="id") String id, @RequestParam(value="uuid") String uuid, @RequestParam(value="path", required=false) String path, @RequestParam(value="name", required=false) String name) {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>(4);
        rtnMap.put("status", "OK");
        rtnMap.put("message", "\u5220\u9664\u6587\u4ef6\u6210\u529f");
        try {
            String newsInfo = this.sysNewsService.deleteSysNewsFile(id, uuid);
            rtnMap.put("newsInfo", newsInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            rtnMap.put("status", "FAILURE");
            rtnMap.put("message", "\u5220\u9664\u6587\u4ef6\u5931\u8d25!\u539f\u56e0\u662f:" + e.getMessage());
        }
        return rtnMap;
    }

    @ApiOperation(value="11-\u8be6\u60c5")
    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    public BaseResponse detail(@RequestParam(value="id") String id) {
        DataResponse responseDataBase = new DataResponse();
        try {
            responseDataBase.setResult(this.sysNewsService.getById((Serializable)((Object)id)));
            responseDataBase.setShowData(true);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return responseDataBase;
    }
}

